<?php

namespace App\Http\Controllers\Api\v1;

use App\Faculty;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class SpeakerController extends Controller
{
    public function show($id){
        $speaker = Faculty::where('id', $id)->firstOrFail();
        $speaker->description = strip_tags($speaker->description);
        $podcasts = $speaker->podcasts()->get();

        $podcasts = $podcasts->map(function ($podcast) {
            return $podcast->podcastForApi($podcast->podcast_id) ?: null;
        })->filter()->values();

        return response()->json([
            "message" => "Speaker fetched successfully.",
            "speaker" => $speaker,
            "podcasts" => $podcasts
        ]);

    }
}
