<?php

namespace App\Http\Controllers\Api\v2;

use App\Faculty;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class SpeakerController extends Controller
{
    public function show($id){
        $speaker = Faculty::where('id', $id)->firstOrFail();
        $speaker->description = strip_tags($speaker->description);
        // Paginate the podcasts (adjust perPage as needed)
        $perPage =siteconfig('api_pagination');; // default to 20 per page
        $paginated = $speaker->podcasts()->paginate($perPage);

        // Transform each podcast using podcastForApi
        $podcastItems = collect($paginated->items())->map(function ($podcast) {
            return $podcast->podcastForApi($podcast->podcast_id);
        })->filter()->values();

        return response()->json([
            "message" => "Speaker fetched successfully.",
            "speaker" => $speaker,
            "podcasts" => $podcastItems,
            "current_page" => $paginated->currentPage(),
            "last_page" => $paginated->lastPage(),
            "per_page" => $paginated->perPage(),
            "total" => $paginated->total(),
        ]);

    }
}
