<?php

namespace App\Http\Controllers\Api\v2;

use App\Http\Controllers\Controller;
use App\Submissions;
use App\Subscription;
use App\User;
use App\UserCredits;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class SubmissionController extends Controller
{

    public function checkSubmissionType(Request $request)
    {
        if ($request->isJson()) {
            $data = $request->json()->all();
            $submissions = new Submissions();

            if (is_array($data)) {
                if (isset($data[0]) && is_array($data[0])) {
                    // Log::info("Called multi submission");
                    return $this->multipleStore($request);
                } else {
                    // Log::info("Called single submission");
                    return $this->store($request, $submissions);
                }
            }
        }

        return response()->json(['error' => 'Invalid request payload'], 400);
    }

    public function sortRangesAscending($array) {
        // Sort the collection by the start values of credit_for in ascending order
        $sortedCollection = $array->sortBy(function ($item) {
            return explode('-', $item['credit_for'])[0];
        });

        return $sortedCollection;
    }


    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, Submissions $submissions)
    {
        try {
            $data = $request->all();
            $user = User::find(Auth::user()->id);
            $user_id = $user->id;

            // get subscription to which credits are to be submitted
            $credit_subscription = $user->getActiveSubscription($request->bar_id);
            if (!$credit_subscription) {
                throw new \Exception("Active subscription not found");
            }
            $credit_subscription_id = $credit_subscription->id;
            $credit_subscription_subs_id = $credit_subscription->subscription_id;
            $credit_subscription_bar_user_ref = $credit_subscription->bar_user_references_id;

            $credit_provided_by_the_course = $credit_subscription->hours_needed_per_cycle;

            // $credit_provided_by_the_course = Bar::where("id", $request->bar_id)->first()->hours_needed_per_cycle;

            if (!$credit_provided_by_the_course) {
                throw new \Exception("credit_provided_by_the_course not found");
            }

            $sortedRanges=[];

            $credit_submitted = $user->getCreditsSubmittedForBar($credit_subscription);

            $credits_remaining = max(0, $credit_subscription->remaining_hours_needed_per_cycle);

            $creditAvailableToSubmit= UserCredits::where("user_id", $user_id)
            ->where("content_id", $request->content_id)
            ->where("content_file_id", $request->file_id)
            ->where("content_state_id", $request->state_id)
            ->where("bar_id", $request->bar_id)
            ->where("submission_id", 0)
            ->sum('credit');

            if($creditAvailableToSubmit >= $request->credit){
                if ($credits_remaining > 0) {
                    $request_credit_submitted = $request->credit;
                    $credit_diff=$request->credit-$credits_remaining;
                    if ($credit_diff > 0 ) {

                        $user_credits_sub= UserCredits::where("user_id", $user_id)
                        ->where("content_id", $request->content_id)
                        ->where("content_file_id", $request->file_id)
                        ->where("content_state_id", $request->state_id)
                        ->where("bar_id", $request->bar_id)
                        ->where("submission_id", 0)
                        ->get();
                        $count = $user_credits_sub->count();
                        $sum = $user_credits_sub->sum('credit');
                        $possible_credit_submission = $request_credit_submitted-$credit_diff;

                        if ($possible_credit_submission == ($sum-$credit_diff)) {
                            if($count>1){
                                $credit_left_after_submission = $credits_remaining-$possible_credit_submission;
                                $message = "You are currently left with {$credits_remaining} credits in your account. As a result, you will only be able to submit {$possible_credit_submission} with {$credit_left_after_submission} credits remaining.";
                                return response()->json(['message' => $message, 'status' => 0, 'possible_credits_submission'=>$possible_credit_submission, 'data'=>$data]);
                            }else{
                                $message = "You are currently left with {$credits_remaining} credits in your account. As a result, you will only be able to submit {$possible_credit_submission} credits, to continue utilizing our services and accessing more credits, we kindly urge you to renew your subscription promptly.";
                                return response()->json(['message' => $message, 'status' => 3]);
                            }
                        }


                    } else {
                        $data['user_id'] = $user_id;
                        $data['bar_id'] = $request->bar_id;
                        $data['content_id'] = $request->content_id;
                        $data['content_file_id'] = $request->file_id;
                        $data['content_state_id'] = $request->state_id;
                        $data['subscription_id'] = $credit_subscription_id;
                        $data['stripe_subscription_id'] = $credit_subscription_subs_id;

                        // check if user has already submitted any credits for this content
                        $previous_credit_submitted = $credit_submitted;
                            if($previous_credit_submitted != 0){
                                // if($request->credit > $previous_credit_submitted){
                                //     $new_credits_to_be_submitted = $request->credit-$previous_credit_submitted;
                                // }else{
                                    $new_credits_to_be_submitted =$request->credit;
                                // }
                                // else{
                                //     $new_credits_to_be_submitted = $previous_credit_submitted-$request->credit;
                                // }
                                $data['credit_submitted'] = $new_credits_to_be_submitted;
                            }else{
                                $data['credit_submitted'] = $request->credit;
                            }

                        if($data['credit_submitted'] !=0){

                            $user_credits_sub= UserCredits::where("user_id", $user_id)
                            ->where("content_id", $request->content_id)
                            ->where("content_file_id", $request->file_id)
                            ->where("content_state_id", $request->state_id)
                            ->where("bar_id", $request->bar_id)
                            ->where("submission_id", 0)
                            ->get();

                            $user_credits_sum= UserCredits::where("user_id", $user_id)
                            ->where("content_id", $request->content_id)
                            ->where("content_file_id", $request->file_id)
                            ->where("content_state_id", $request->state_id)
                            ->where("submission_id", 0)
                            ->where("bar_id", $request->bar_id)
                            ->sum("credit");

                            $earned_credits =  $user_credits_sum;
                            if(($earned_credits == $request->video_credit) && ($request->credit < $earned_credits)){
                                return response()->json([
                                    'message' => 'You are attempting to submit less credits than you have earned or credits have already been submitted.',
                                    'status' => 2
                                ]);
                            }

                            $submissions->fill($data);
                            $submissions->save();

                            //create and send submission certification.
                            $submissionId = $submissions->id;

                            // update the subscriptions table remaining hours fields
                            $credit_submitted = Submissions::where("user_id", $user_id)
                            ->where("bar_id", $request->bar_id)
                            ->where("subscription_id", $credit_subscription_id)
                            ->where("stripe_subscription_id", $credit_subscription_subs_id)
                            ->sum('credit_submitted');

                            $subscribed_credits_remaining = max(0, $credit_provided_by_the_course - $credit_submitted);

                            DB::table('subscriptions')
                                ->where('id', $credit_subscription_id)
                                ->update(['remaining_hours_needed_per_cycle' => $subscribed_credits_remaining]);

                            // add the submission id in the user_credits table
                            
                            if ($user_credits_sub) {
                                $credits_submitted= $request->credit;
                                $credits_remaining= $user_credits_sum-$credits_submitted;
                                if($credits_remaining==0){
                                    $sortedRanges = $this->sortRangesAscending($user_credits_sub);
                                    // Update the submission_id in user_credits
                                    DB::table('user_credits')
                                    ->whereIn('id', $sortedRanges->pluck('id'))
                                    ->update(['submission_id' => $submissionId]);
                                }
                            }
                            return response()->json(['message' => 'Submission data successfully saved.', 'status' => 1, 'user_id'=> $user_credits_sub]);
                        }else{
                            return response()->json(['message' => 'Credits already submitted, please earn more credits to submit', 'status' => 4]);
                        }

                    }
                } else {
                    return response()->json([
                        'message' => 'Your current subscription has been exhausted, and your access to credits has been temporarily suspended. To continue utilizing our services and accessing more credits, we kindly urge you to renew your subscription promptly.',
                        'status' => 3,
                        'bar_user_ref'=>$credit_subscription_bar_user_ref,
                        'subscription_id'=>$credit_subscription_id
                    ]);
                }
            }else{
                return response()->json([
                    'message' => 'You are attempting to submit more credits than you have or credits have already been submitted.',
                    'status' => 2
                ]);
            }

        } catch (\Exception $e) {
            return response()->json(['message' => $e->getMessage(), 'status' => 2]);
        }
    }


    // multiple submission 
    public function multipleStore(Request $request)
    {
        $results = [];

        try {
            $data = $request->all();
            $user = User::find(Auth::user()->id);
            $user_id = $user->id;
            $submitted_credit_sum = 0 ;

            foreach($data as $index => $submissionData){
                $data_bar_id = $submissionData['bar_id'];
                $data_file_id = $submissionData['file_id'];
                $data_state_id = $submissionData['state_id'];
                $data_credit = $submissionData['credit'];
                $data_content_id = $submissionData['content_id'];
                $data_video_credit = $submissionData['video_credit'];

                // get subscription to which credits are to be submitted
                $credit_subscription = $user->getActiveSubscription($data_bar_id);
                if (!$credit_subscription) {
                    throw new \Exception("Active subscription not found for Bar ID: $data_bar_id");
                }
                $credit_subscription_id = $credit_subscription->id;
                $credit_subscription_subs_id = $credit_subscription->subscription_id;
                $credit_subscription_bar_user_ref = $credit_subscription->bar_user_references_id;

                $credit_provided_by_the_course = $credit_subscription->hours_needed_per_cycle;
                $remaining_hours_needed_per_cycle = $credit_subscription->remaining_hours_needed_per_cycle;

                // $credit_provided_by_the_course = Bar::where("id", $data_bar_id)->first()->hours_needed_per_cycle;

                if (!$credit_provided_by_the_course) {
                    throw new \Exception("credit_provided_by_the_course not found");
                }

                $sortedRanges=[];

                $credit_submitted = $user->getCreditsSubmittedForBar($credit_subscription);

                $credits_remaining = max(0, $credit_subscription->remaining_hours_needed_per_cycle);


                $creditAvailableToSubmit= UserCredits::where("user_id", $user_id)
                ->where("content_id", $data_content_id)
                ->where("content_file_id", $data_file_id)
                ->where("content_state_id", $data_state_id)
                ->where("bar_id", $data_bar_id)
                ->where("submission_id", 0)
                ->sum('credit');

                if($creditAvailableToSubmit >= $data_credit){
                    if ($credits_remaining > 0) {
                        $credit_diff=$data_credit-$credits_remaining;
                        if ($credit_diff > 0 ) {

                            $user_credits_sub= UserCredits::where("user_id", $user_id)
                            ->where("content_id", $data_content_id)
                            ->where("content_file_id", $data_file_id)
                            ->where("content_state_id", $data_state_id)
                            ->where("bar_id", $data_bar_id)
                            ->where("submission_id", 0)
                            ->get();
                            $count = $user_credits_sub->count();
                            $sum = $user_credits_sub->sum('credit');
                            $possible_credit_submission = $data_credit-$credit_diff;
    
                            if ($possible_credit_submission == ($sum-$credit_diff)) {
                                if($count>1){
                                    $credit_left_after_submission = $credits_remaining-$possible_credit_submission;
                                    $message = "You are currently left with {$credits_remaining} credits in your account. As a result, you will only be able to submit {$possible_credit_submission} with {$credit_left_after_submission} credits remaining.";
                                    return response()->json(['message' => $message, 'status' => 0, 'possible_credits_submission'=>$possible_credit_submission, 'data'=>$submissionData]);
                                }else{
                                    $message = "You are currently left with {$credits_remaining} credits in your account. As a result, you will only be able to submit {$possible_credit_submission} credits, to continue utilizing our services and accessing more credits, we kindly urge you to renew your subscription promptly.";
                                    return response()->json(['message' => $message, 'status' => 3]);
                                }
                            }
    
    
                        }  else {
                            $data['user_id'] = $user_id;
                            $data['bar_id'] = $data_bar_id;
                            $data['content_id'] = $data_content_id;
                            $data['content_file_id'] = $data_file_id;
                            $data['content_state_id'] = $data_state_id;
                            $data['subscription_id'] = $credit_subscription_id;
                            $data['stripe_subscription_id'] = $credit_subscription_subs_id;

                            // check if user has already submitted any credits for this content
                            $previous_credit_submitted = $credit_submitted;
                                if($previous_credit_submitted != 0){
                                    // if($data_credit > $previous_credit_submitted){
                                    //     $new_credits_to_be_submitted = $data_credit-$previous_credit_submitted;
                                    // }else{
                                        $new_credits_to_be_submitted = $data_credit;
                                    // }
                                    // else{
                                    //     $new_credits_to_be_submitted = $previous_credit_submitted-$data_credit;
                                    // }
                                    $data['credit_submitted'] = $new_credits_to_be_submitted;
                                }else{
                                    $data['credit_submitted'] = $data_credit;
                                }

                            if($data['credit_submitted'] !=0){

                                $user_credits_sub= UserCredits::where("user_id", $user_id)
                                ->where("content_id", $data_content_id)
                                ->where("content_file_id", $data_file_id)
                                ->where("content_state_id", $data_state_id)
                                ->where("bar_id", $data_bar_id)
                                ->where("submission_id", 0)
                                ->get();

                                $earned_credits= $user_credits_sub->sum("credit");

                                if(($earned_credits == $data_video_credit) && ($data_credit < $earned_credits)){
                                    // $results[] = [
                                    //     'message' => 'You are attempting to submit less credits than you have earned or credits have already been submitted.',
                                    //     'status' => 2,
                                    // ];
                                    return response()->json([
                                        'message' => 'You are attempting to submit less credits than you have earned or credits have already been submitted.',
                                        'status' => 2
                                    ]);
                                }

                                $submissions = new Submissions();
                                $submissions->fill($data);
                                $submissions->save();
                                // $submissions->fill($data);
                                // $submissions->save();

                                //create and send submission certification.
                                $submissionId = $submissions->id;

                                // update the subscriptions table remaining hours fields
                                // $credit_submitted = Submissions::where("user_id", $user_id)
                                // ->where("bar_id", $data_bar_id)
                                // ->where("subscription_id", $credit_subscription_id)
                                // ->where("stripe_subscription_id", $credit_subscription_subs_id)
                                // ->sum('credit_submitted');

                                $subscribed_credits_remaining = max(0, $remaining_hours_needed_per_cycle - $data_credit);

                                DB::table('subscriptions')
                                    ->where('id', $credit_subscription_id)
                                    ->update(['remaining_hours_needed_per_cycle' => $subscribed_credits_remaining]);

                                // add the submission id in the user_credits table
                                
                                if ($user_credits_sub) {
                                    $credits_remaining= $earned_credits - $data_credit;
                                    if($credits_remaining == 0){
                                        $sortedRanges = $this->sortRangesAscending($user_credits_sub);
                                        // Update the submission_id in user_credits
                                        DB::table('user_credits')
                                        ->whereIn('id', $sortedRanges->pluck('id'))
                                        ->update(['submission_id' => $submissionId]);
                                    }
                                }
                                $results[] = [
                                    'status' => 1,
                                    'message' => 'Submission data successfully saved.',
                                    'submissionId' => $submissionId,
                                ];

                                $submitted_credit_sum = $submitted_credit_sum + $data_credit;
                                // return response()->json(['message' => 'Submission data successfully saved.', 'status' => 1, 'user_id'=> $user_credits_sub]);
                            }else{
                                $results[] = [
                                    'status' => 4,
                                    'message' => 'Credits already submitted, please earn more credits to submit',
                                ];
                                // return response()->json(['message' => 'Credits already submitted, please earn more credits to submit', 'status' => 4]);
                            }

                        }
                    } else {
                        $results[] = [
                            'message' => 'Your current subscription has been exhausted, and your access to credits has been temporarily suspended. To continue utilizing our services and accessing more credits, we kindly urge you to renew your subscription promptly.',
                            'status' => 3,
                            'bar_user_ref'=>$credit_subscription_bar_user_ref,
                            'subscription_id'=>$credit_subscription_id,
                        ];
                        // return response()->json([
                        //     'message' => 'Your current subscription has been exhausted, and your access to credits has been temporarily suspended. To continue utilizing our services and accessing more credits, we kindly urge you to renew your subscription promptly.',
                        //     'status' => 3,
                        //     'bar_user_ref'=>$credit_subscription_bar_user_ref,
                        //     'subscription_id'=>$credit_subscription_id
                        // ]);
                    }
                }else{
                    $results[] = [
                        'message' => 'You are attempting to submit more credits than you have or credits have already been submitted.',
                        'status' => 2,
                    ];
                    // return response()->json([
                    //     'message' => 'You are attempting to submit more credits than you have or credits have already been submitted.',
                    //     'status' => 2
                    // ]);
                }
            }
        } catch (\Exception $e) {
            return response()->json(['message' => $e->getMessage(), 'status' => 2]);
        }
        return response()->json(end($results));
    }



    public function submitPartialCredits(Request $request, Submissions $submissions){
        try {
            // Validate the request data
            $request->validate([
                'bar_id' => 'required|integer',
                'content_id' => 'required|integer',
                'file_id' => 'required|integer',
                'state_id' => 'required|integer',
                'credit' => 'required|numeric|min:0',
            ]);

            // Fetch the authenticated user
            $user = User::find(Auth::user()->id);
            if (!$user) {
                throw new \Exception("User not authenticated");
            }
            $user_id = $user->id;
            $credit_subscription = $user->getActiveSubscription($request->bar_id);
            if (!$credit_subscription) {
                throw new \Exception("Active subscription not found");
            }

            $creditAvailableToSubmit= UserCredits::where("user_id", $user_id)
            ->where("content_id", $request->content_id)
            ->where("content_file_id", $request->file_id)
            ->where("content_state_id", $request->state_id)
            ->where("bar_id", $request->bar_id)
            ->where("submission_id", 0)
            ->sum('credit');

            if($creditAvailableToSubmit >= $request->credit){
                $data = [
                    'user_id' => $user->id,
                    'bar_id' => $request->bar_id,
                    'content_id' => $request->content_id,
                    'content_file_id' => $request->file_id,
                    'content_state_id' => $request->state_id,
                    'subscription_id' => $credit_subscription->id,
                    'stripe_subscription_id' => $credit_subscription->subscription_id,
                    'credit_submitted' => $request->credit,
                ];

                // Fill the submission model with the data
                $submissions->fill($data);
                $submissions->saveOrFail();
                // Save the submission
                // if (!$submissions->saveOrFail()) {
                //     throw new \Exception("Submission not saved");
                // }

                //create and send submission certification.
                $submissionId = $submissions->id;

                // Calculate the total credits submitted
                $credit_submitted = Submissions::where("user_id", $user->id)
                    ->where("bar_id", $request->bar_id)
                    ->where("subscription_id", $credit_subscription->id)
                    ->where("stripe_subscription_id", $credit_subscription->subscription_id)
                    ->sum('credit_submitted');

                $credit_provided_by_the_course = $credit_subscription->hours_needed_per_cycle;
                $subscribed_credits_remaining = max(0, $credit_provided_by_the_course - $credit_submitted);

                // Update the subscriptions table
                DB::table('subscriptions')
                    ->where('id', $credit_subscription->id)
                    ->update(['remaining_hours_needed_per_cycle' => 0]);

                // Add the submission ID in the user_credits table
                $user_credits_sub = UserCredits::where("user_id", $user->id)
                    ->where("content_id", $request->content_id)
                    ->where("content_file_id", $request->file_id)
                    ->where("content_state_id", $request->state_id)
                    ->where("bar_id", $request->bar_id)
                    ->where("submission_id", 0)
                    ->get();

                $sortedRanges = $this->sortRangesAscending($user_credits_sub);
                $credits_submitted = $request->credit;
                $totalCredits = 0;

                if ($sortedRanges) {
                    foreach ($sortedRanges as $userCredit) {
                        $remainingCredits = $credits_submitted - $totalCredits;

                        if ($userCredit->credit <= $remainingCredits) {
                            $totalCredits += $userCredit->credit;
                            // Update the submission_id in user_credits
                            DB::table('user_credits')
                                ->where('id', $userCredit->id)
                                ->update(['submission_id' => $submissionId]);
                        } else {
                            break; // Exit the loop if adding this credit would exceed the submitted amount
                        }
                    }
                }

                return response()->json(['message' => 'Submission data successfully saved.', 'status' => 1, 'sortedRanges' => $sortedRanges]);
            }else{
                return response()->json([
                    'message' => 'You are attempting to submit more credits than you have or credits have already been submitted.',
                    'status' => 2
                ]);
            }


        } catch (\Exception $e) {
            // Log the error message
            Log::error('Error in submitPartialCredits: ' . $e->getMessage());
            return response()->json(['message' => $e->getMessage(), 'status' => 2]);
        }
    }


    public function getSubscriptions(Request $request)
    {
        $user_id = Auth::user()->id;
        $bar_id=$request->bar_id;
        if($user_id){
            $subscription = Subscription::where('user_id', $user_id)->where('bar_id', $bar_id)->get();
            return response()->json(["message" => "Subscription fetched successfully.", 'data' => $subscription]);
        }else{
            return response()->json(["message" => "Subscription not found."]);
        }

    }



    // submissions export

    // public function export()
    // {
    //     return Excel::download(new SubmissionExport, 'submissions.xlsx');
    // }
}
