<?php

namespace App\Http\Controllers\Api\v2;

use App\Support;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use App\Notifications\SupportNotification;
use Illuminate\Support\Facades\Notification;

class SupportController extends Controller
{
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try{
            $support=new Support;
            $data = $request->all();
            $user = User::find(Auth::user()->id);
            $data['user_id'] = $user->id;
            
            $data['firm_name']= !empty($user->firmcode) ? $user->firmcode : null;

            $support->fill($data);
            $support->save();
                $users = [];
                if(!empty(siteconfig('support_email'))){
                    $emails = explode(',',siteconfig('support_email'));
                    foreach ($emails as $email) {
                        $user = User::make(['email' => $email]);
                        $users[] = $user;
                    }
                }
    
                Notification::sendNow($users, new SupportNotification($support));
                return response()->json(['message' => 'Support request sent successfully']);
            
            
        } catch (\Exception $e) {
            return response()->json(['message' => $e->getMessage()]);
        }
    }
}