<?php

namespace App\Http\Controllers\Api\v2;

use App\Bar;
use App\BarUserReference;
use App\Http\Controllers\Controller;
use App\Submissions;
use App\User;
use App\UserCredits;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UserCreditsController extends Controller
{
    public function getUserCredit()
    {
        $user = User::find(Auth::user()->id);
        $userCredit = [];

        $user_bars = $user->getUserBars(0);

        if ($user_bars->count() > 0) {
            foreach ($user_bars as $key => $user_bar) {
                $bar = Bar::where('id', $user_bar->bar_id)->first();
                $user_bar_id = $user_bar->bar_id;

                $credits = UserCredits::select('id', 'user_id', 'content_state_id', 'content_id', 'content_file_id', 'credit', 'credit_for', 'submission_id', 'created_at', 'updated_at')->where('user_id', Auth::user()->id)->whereHas('contentsState', function ($q) use ($user_bar_id) {
                    $q->where('bar_id', $user_bar_id);
                });

                // Sort the credits by submission_id
                $credits= $credits->orderBy('submission_id', 'asc');

                $creditsData = [];
                foreach ($credits->get() as $credit) {
                    $creditArray = $credit->toArray();
                    $creditArray['video_credit'] = getVideoCreditsForBar($credit->content_file_id, $user_bar_id);
                    $creditsData[] = $creditArray;
                }

                $userCredit[] = [
                    'id' => $bar->id,
                    'bar_name' => $bar->state_name,
                    'total_credit' => $credits->sum('credit'),
                    'credits' => $creditsData,
                ];
            }
        }
        $data['barWiseCredits'] = $userCredit;

        return response()->json(["message" => "User Credit fetched successfully2.", 'data' => $data]);
    }

    public function getUserCreditById(Request $request)
    {
        $user = User::find(Auth::user()->id);
        $userCredit = [];

        $user_bars = $user->getUserBars($request->id);

        if ($user_bars->count() > 0) {
            foreach ($user_bars as $key => $user_bar) {
                $bar = Bar::where('id', $user_bar->bar_id)->first();
                $user_bar_id = $user_bar->bar_id;
                if ($user->getActiveSubscription($user_bar_id)) {
                    $user_subscription_id = $user->getActiveSubscription($user_bar_id)->subscription_id;
                    $data['bar_name']=$bar->state_name;
                    $data['current_submission']  = Submissions::select('credit_submitted', 'id', 'created_at', 'bar_id', 'content_file_id', 'content_id', 'content_state_id','certificate_file')->where('stripe_subscription_id', $user_subscription_id)->orderBy('id','desc')->get();

                    $data['submission_history']  = Submissions::select('credit_submitted', 'id', 'created_at', 'bar_id', 'content_file_id', 'content_id', 'content_state_id','certificate_file')->where('user_id', $user->id)->where('stripe_subscription_id', '!=', $user_subscription_id)->orderBy('id','desc')->get();

                    $submissionsCredit = Submissions::where('stripe_subscription_id', $user_subscription_id)->sum('credit_submitted');
                    $data['totalSubmittedCredit'] = $submissionsCredit;
                }else{
                    $data = [];
                }
                
            }
        }

        return response()->json(["message" => "User Credit fetched successfully.1", 'data' => $data]);
    }


public function getVideoCredits(Request $request) {
    $user = User::find(Auth::user()->id);
    $sectomins = secondsToMinute($request->video_length);
    $data = $request->all();
    $approvedStates = $data['states_approved'];

    foreach ($approvedStates as &$state) {
        $barId = $state['bar_id'];

        // get subscription to which credits are to be submitted
        $user_bar_subscription=$user->getActiveSubscription($barId);

        if($user_bar_subscription){
            $credit_provided_by_the_course = $user_bar_subscription->hours_needed_per_cycle;

            $state['credit_provided_by_the_course'] = $credit_provided_by_the_course ? $credit_provided_by_the_course : null;

            $creditProvidedByVideoForBar= floor($sectomins/$credit_provided_by_the_course)*0.25;
            $creditEarnedByVideoForBar = UserCredits::where('user_id',$data['user_id'])->where('content_file_id',$data['video_id'])->where('content_id',$state['contents_id'])->where('bar_id',$barId)->sum('credit');
            $creditLeftToProvideByVideoForBar=$creditEarnedByVideoForBar > 0 ? ($creditEarnedByVideoForBar >= $creditProvidedByVideoForBar ? 0 : $creditProvidedByVideoForBar-$creditEarnedByVideoForBar) : $creditProvidedByVideoForBar;

            $state['creditProvidedByVideoForBar']=$creditProvidedByVideoForBar;
            $state['creditLeftToProvideByVideoForBar']=$creditLeftToProvideByVideoForBar;

            $creditSubmittedForBar = $user->getCreditsSubmittedForBar($user_bar_subscription);
            $state['creditSubmittedForBar'] = $creditSubmittedForBar;

            $credits_remaining = max(0, ($credit_provided_by_the_course) - $creditSubmittedForBar);
            $state['credits_remaining'] = $credits_remaining;

            $is_paid = BarUserReference::select('is_paid','created_at')->where("user_id", $request->user_id)
                    ->where("bar_id", $barId)->latest('created_at')->first()->is_paid;
                    $state['is_paid'] = $is_paid;
                    break;
        }

    }

    return response()->json([
        "message" => "User Credit fetched successfully.",
        'states_approved' => $approvedStates,
    ]);
}

}
