<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Hash;
use Auth;
use Validator;
use App\User;
use App\UserType;
use Illuminate\Support\Facades\Log;

class ChangePassword extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
    }

    /**
     * Display the change password view for the existing user.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function showChangePasswordForm()
    {
        return view('admin.modules.auth.passwords.change');
    }

    public function updatePassword(Request $request)
    {

        //get and use of minimum charctor value and password strength from site config
        $passwordValidationRule = ['required'];
       $passwordPolicy = getPasswordPolicy($passwordValidationRule);

        $messages = [
            'confirm_password.same' => __('changepassword.validation_new_confirm_password_same'),
            'new_password.regex' => __('user.password_rule_'.$passwordPolicy['passwordStrength'].'_msg', array('min'=>$passwordPolicy['passwordMinLength']))
        ];
        $validator = Validator::make($request->all(), [
                'old_password' => ['required',function ($attribute, $value, $fail) {
                    if (!Hash::check($value, Auth::User()->password)) {
                        $fail(__('changepassword.validation_invalid_current_password',['attribute' => str_replace("-"," ",$attribute)]));
                    }
                }],
                'new_password' =>$passwordPolicy['passwordValidationRule'],
                'confirm_password' => 'required|same:new_password',
        ], $messages);

        if ($validator->fails()) {
            return $validator->validate();
        }

        //Change Password
        $user = Auth::user();
        $user->password = bcrypt($request->get('new_password'));
        $user->save();
        if ($this->apiUrl() !== false) {
            return response()->json(['message'=>__('changepassword.success')]);
        }
        else{
            return redirect()->back()->with("success", __('changepassword.success'));
        }

    }

    public function updateAdminPassword(Request $request)
    {

        //get and use of minimum charctor value and password strength from site config
        $passwordValidationRule = ['required'];
       $passwordPolicy = getPasswordPolicy($passwordValidationRule);

        $messages = [
            'password-confirm.same' => __('changepassword.validation_new_confirm_password_same'),
            'new-password.regex' => __('user.password_rule_'.$passwordPolicy['passwordStrength'].'_msg', array('min'=>$passwordPolicy['passwordMinLength']))
        ];
        $validator = Validator::make($request->all(), [
                'current-password' => ['required',function ($attribute, $value, $fail) {
                    if (!Hash::check($value, Auth::User()->password)) {
                        $fail(__('changepassword.validation_invalid_current_password',['attribute' => str_replace("-"," ",$attribute)]));
                    }
                }],
                'new-password' =>$passwordPolicy['passwordValidationRule'],
                'password-confirm' => 'required|same:new-password',
        ], $messages);

        if ($validator->fails()) {
            return $validator->validate();
        }

        //Change Password
        $user = Auth::user();
        $user->password = bcrypt($request->get('new-password'));
        $user->save();
        if ($this->apiUrl() !== false) {
            return response()->json(['message'=>__('changepassword.success')]);
        }
        else{
            return redirect()->back()->with("success", __('changepassword.success'));
        }

    }
}
