<?php

namespace App\Http\Controllers\Common;

use App\Content;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\View;

class RssFeedController extends Controller
{
    public function index()
    {
        $rss = Cache::remember('rss.feed', now()->addDay(), function () {
            $contents = Content::where('status',1)->latest('created_at')->take(50)->get();
            $rssContent = View::make('feed.rss', compact('contents'))->render();

            // Optional: Write RSS feed to public/rss.xml for CDN purposes
            file_put_contents(public_path('rss.xml'), $rssContent);

            return $rssContent;
        });

        return response($rss, 200)
            ->header('Content-Type', 'application/rss+xml');
    }
}
