<?php

namespace App\Http\Controllers\Common;

use App\ContentFiles;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use getID3;
use Illuminate\Support\Facades\Log;

class UploadController extends Controller
{
    protected $imgFolderStartWith = 'image-sizes.';
    protected $imgFolderEndWith = '.sizes';

    public function store(Request $request)
    {
        // Set max execution time to zero to avoid max execution time error.
        ini_set('max_execution_time', '0');


        $size = $request->post('size') * 1024;
        $folder = $request->get('folder', 'uploads');

        if( $folder == 'userdocument' || $folder == 'capture_document' ){
            $rules = ['file' => 'required|mimes:pdf,doc,docx|max:'.$size];
            $mimeTypes = 'PDF/DOC/DOCX';
            $messages = [
                'file.mimes' => 'The uploaded attachment extension is invalid. Attachment must be file of type: '.$mimeTypes,
                'file.max' => 'The file may not be greater than '.$request->post('size').' MB.'
            ];
            $this->validate($request, $rules, $messages);

            $visibility = 'public';

            $file = request()->file('file');
            $file_extension = $file->getClientOriginalExtension();
            $file_name =  $file->getClientOriginalName().date('YmdHis').'.'.$file_extension;

            $storage_file = Storage::putFileAs($folder, request()->file('file'), $file_name, $visibility);
            $storage_file_url = getMediaUrl($storage_file, $visibility);

            return response()->json(['location' => $storage_file_url, 'file' => $file_name]);
        }
        else{
            if($request->extension && $request->extension != 'undefined'){
                $rules = ['file' => 'required|mimes:'.$request->extension.'|max:'.$size];
            }else{
                $rules = ['file' => 'required|mimes:jpeg,png,jpg,gif|max:'.$size];
            }
            $messages = [
                'file.mimes' => 'The uploaded image extension is invalid. Image must be file of type: JPEG/JPG/PNG/GIF',
                'file.max' => 'The file may not be greater than '.$request->post('size').' MB.'
            ];
            if($request->extension && $request->extension != 'undefined'){
                $messages['file.mimes'] = 'The uploaded '.$request->folder.' extension is invalid.<br/> '.ucfirst($request->folder).' must be file of type: '.str_replace(",","/",$request->extension);
            }
            $this->validate($request, $rules, $messages);


            $visibility = getMediaVisibility(config('image-sizes.'.$folder.'.visibility'));

            $file = request()->file('file');
            $file_extension = $file->getClientOriginalExtension();
            $file_name = hash("sha512",explode('.'.$file_extension, $file->getClientOriginalName())[0].time()).'.'.$file_extension;

            $storage_file = Storage::putFileAs($folder, request()->file('file'), $file_name, $visibility);
            $storage_file_url = getMediaUrl($storage_file, $visibility);

            if($request->extension && $request->extension != 'undefined'){

            }
            else{
                // Generate Resized Images
            foreach (config('image-sizes.'.$folder.'.sizes', []) as $prefix => $image) {
                $resizeFile = Image::make(request()->file('file'));

                switch ($image['method']) {

                    case 'fit': {
                        $resizeFile->resize($image['width'], $image['height'], function ($constraint) {
                            $constraint->aspectRatio();
                        });
                        break;
                    }
                    case 'crop':
                    default:
                    {
                        $resizeFile->fit($image['width'], $image['height'])->crop($image['width'], $image['height']);
                        break;
                    }

                }
                $resizeFile->encode(null, config('image.quality'));
                Storage::put($folder."/".$prefix.'-'.$file_name, (string) $resizeFile, $visibility);
            }

            }

            return response()->json(['location' => $storage_file_url, 'file' => $file_name]);
        }


    }

    /**
     * Upload multiple Files
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function uploadMultipleFile(Request $request)
    {
        // Set max execution time to zero to avoid max execution time error.
        ini_set('max_execution_time', '0');
        ini_set('post_max_size', '1024M');;
        ini_set('upload_max_filesize', '1024M');
        // Log::info(phpinfo());
        $folder = 'upload_file';
        $visibility = getMediaVisibility(config($this->imgFolderStartWith.$folder.'.visibility'));

        $files = $request->file('files');
        $uploadefiles = array();
        $cnt = 0;

        foreach ($files as $file) {
            $getData = new getID3();
            $duration = 0;

            $filePath = $file->getRealPath();

            // Get the duration of the MP3 file
            $fileInfo = $getData->analyze($filePath);
            if(isset($fileInfo['playtime_seconds'])) {
                $duration = $fileInfo['playtime_seconds'];
            }

            $file_extension = $file->getClientOriginalExtension();
            $file_name =explode('.'.$file_extension, $file->getClientOriginalName())[0].'_'.time().'.'.$file_extension;

            $storage_file = Storage::putFileAs($folder, $file, $file_name, $visibility);
            $storage_file_url = getMediaUrl($storage_file, $visibility);

            $uploadefiles['files'][$cnt]['name'] = $file_name;
            $uploadefiles['files'][$cnt]['size'] = (int)  $file->getSize();
            $uploadefiles['files'][$cnt]['type'] = $file->getMimeType();
            $uploadefiles['files'][$cnt]['tmp_name'] = $file->getFilename();
            $uploadefiles['files'][$cnt]['thumbnailUrl'] = $storage_file_url;
            $uploadefiles['files'][$cnt]['duration'] = secondsToMinuteSecond($duration);

            $cnt++;
        }
        return response()->json($uploadefiles);
    }
    public function deleteFile(Request $request)
    {
        try {
            $folder = 'upload_file';
            $visibility = getMediaVisibility(config($this->imgFolderStartWith . $folder . '.visibility'));
            $disk = ($visibility === 'private') ? 'local' : 'public';
    
            if (!$request->has('file')) {
                return response()->json(['success' => false, 'message' => 'No file provided.'], 400);
            }
    
            $filePath = $request->file;
            $fileFullPath = "upload_file\\" . $filePath;
    
            Log::info("Checking file existence: " . Storage::disk()->path($fileFullPath));
    
            if (!Storage::disk()->exists($fileFullPath)) {
                return response()->json(['success' => false, 'message' => 'File not found.'], 404);
            }
    
            if (!Storage::disk()->delete($fileFullPath)) {
                return response()->json(['success' => false, 'message' => 'Failed to delete file.'], 500);
            }
    
            return response()->json(['success' => true, 'message' => 'File deleted successfully.']);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'An error occurred while deleting the file.',
                'error' => $e->getMessage()
            ], 500);
        }
    }
}
