<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    protected $is_valid_link;

    public function __construct()
    {
        if (Auth::check() && Auth::user()->status == 0) {
            Auth::logout();
        }
    }

    public function apiUrl()
    {
        $currentRoute = Route::getCurrentRoute();
        $currentUri = $currentRoute->uri(); 
    
        return (strpos($currentUri, 'api/v1') !== false || strpos($currentUri, 'api/v2') !== false);
    }

    public function stripHtmlTags(Request $request, array $notStripTags = [])
    {
        $requestParams = $request->all();
        foreach ($requestParams as $key=>$value) {
            if (!is_array($requestParams[$key]) &&  !in_array($key, $notStripTags) && isset($value) && !empty($value) && $value != null) {
                    $requestParams[$key]=strip_tags($value);
            }
        }
        $request->replace($requestParams);

        return $request;
    }

}
