<?php

namespace App\Http\Controllers\Front;

use App\Category;
use App\ContactUs;
use App\FacultyInquiry;
use App\Http\Controllers\Controller;
use App\Notifications\ContactUsDataNotification;
use App\Notifications\FacultyInquiryNotification;
use App\Page;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Notification;
use Illuminate\Validation\ValidationException;

class ContactController extends Controller
{
    public function submitContactUs(Request $request)
    {
        try {
            // Validate the reCAPTCHA response along with other form fields
            $request->validate([
                'g-recaptcha-response' => ['required', 'recaptcha'],
            ]);

            $contactUs = new ContactUs();

            $data = $request->all();
            if (!empty($data['phone_number'])) {
                $data['phone_number'] = preg_replace('/\D/', '', $data['phone_number']);
            }

            $contactUs->fill($data);
            $contactUs->save();

            // Send notifications to users
            $users = [];
            if (!empty(siteconfig('connects_email'))) {
                $emails = explode(',', siteconfig('connects_email'));
                foreach ($emails as $email) {
                    $user = User::make(['email' => $email]);
                    $users[] = $user;
                }
            }

            Notification::sendNow($users, new ContactUsDataNotification($contactUs));

            return redirect()->back()->with('success', "Contact request has been submitted. We will contact you soon.");
        } catch (ValidationException $e) {
            // Return with error message if validation fails
            return redirect()->back()
                ->withErrors($e->errors())
                ->withInput()
                ->with('error', "Validation failed. Please check the form and try again.");
        }
    }

    public function index()
    {
        $categories = Category::active()->get()->unique('name');
        return view('front.modules.contact.inquiry', compact('categories'));
    }

    public function storeFacultyInquiry(Request $request)
    {
        try {
            $request->validate([
                'g-recaptcha-response' => ['required', 'recaptcha'],
            ]);

            $contactUs = new FacultyInquiry;

            $data = $request->all();

            if (!empty($data['phone_number'])) {
                $data['phone_number'] = preg_replace('/\D/', '', $data['phone_number']);
            }


            $data['ip_address'] = $request->getClientIp(true);
            $contactUs->fill($data);
            $contactUs->save();

            $contactUs->categories()->attach($data['categories']);

            // Send notifications to users
            $users = [];
            if (!empty(siteconfig('connects_email'))) {
                $emails = explode(',', siteconfig('connects_email'));
                foreach ($emails as $email) {
                    $user = User::make(['email' => $email]);
                    $users[] = $user;
                }
            }

            Notification::sendNow($users, new FacultyInquiryNotification($contactUs));
            // Notification::route('mail', 'contact@clearly.legal')->notify(new FacultyInquiryNotification($contactUs));

            return redirect()->back()->with('success', "Faculty request has been submitted. We will contact you soon.");
        } catch (ValidationException $e) {
            // Return with error message if validation fails
            return redirect()->back()
                ->withErrors($e->errors())
                ->withInput()
                ->with('error', "Validation failed. Please check the form and try again.");
        }
    }
}