<?php

namespace App\Http\Controllers\Front;

use App\Content;
use App\Faculty;
use App\FAQs;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Member;
use App\Page;
use Carbon\Carbon;

class HomeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $pages = Page::where(['status' => 1])->get();
    
        $contents = Content::with('contentFiles')
            ->where('status', 1)
            ->whereDate('published_on', '<=', Carbon::now())
            ->orderByDesc('published_on')
            ->limit(6)
            ->get();
    
        $showMore = true;
    
        $faqs = FAQs::active()->orderBy('display_order', 'asc')->get();

        $members = Member::where('status',1)->get()->take(siteconfig('home_member_count',0));
        return view('front.pages.home', compact('pages', 'contents','members','showMore', 'faqs'));
    }
    
    
}
