<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\OAuth;
//Alias the League Google OAuth2 provider class
use League\OAuth2\Client\Provider\Google;
use Stevenmaguire\OAuth2\Client\Provider\Microsoft;
use League\OAuth2\Client\Grant\RefreshToken;
use App\SiteConfig;
use Illuminate\Support\Facades\Log;


class MailController extends Controller
{

    public function oauth2()
    {
        // Log::info('In function oauth2');
        $clientId = siteconfig('mail_client_id'); 
        $clientSecret = siteconfig('mail_client_secret');  
        $tenantId = siteconfig('mail_tenant_id');
        $providerName = siteconfig('mail_providername');
        $redirectUri = route('mailoauth2');

        if ($providerName == 'Google') {
                $params = [
                    'clientId' => $clientId,
                    'clientSecret' => $clientSecret,
                    'redirectUri' => $redirectUri,
                    'accessType'=> 'offline',
                ];
                $provider = new Google($params);
                $options = [
					'access_type'=> 'offline',
                    'scope' => [
                        'https://mail.google.com/'
                    ],
					
                ];
        } elseif ($providerName == 'Microsoft') {
                $params = [
                    'clientId' => $clientId,
                    'clientSecret' => $clientSecret,
                    'redirectUri' => $redirectUri,
                    'urlAuthorize'              => 'https://login.microsoftonline.com/' . $tenantId . '/oauth2/v2.0/authorize',
                    'urlAccessToken'            => 'https://login.microsoftonline.com/' . $tenantId . '/oauth2/v2.0/token',
                ];
                $provider = new Microsoft($params);
                $options = [
                    'scope' => [
                        'https://outlook.office.com/SMTP.Send offline_access'
                    ],
                    'clientId' => $clientId,
                    'clientSecret' => $clientSecret,
                ];
        }
        $accessToken = SiteConfig::where('name','mail_refresh_token')->first();
		$refesh = $accessToken->val;
        if($refesh !== '' && $refesh !== null){
            // Log::info('In function oauth2 if 1');
            $roptions = [
                'clientSecret' => $clientSecret,
                'client_id' => $clientId,
                'redirectUri' => $redirectUri,
                'grant_type' => 'refresh_token',
                'refresh_token' => $refesh,
				'accessType'=> 'offline',
				'prompt'=>'none'
            ];
            $refershtoken = $provider->getAccessToken(
                    'refresh_token',
                    $roptions
                );
			
            echo '1.Refresh Token : ', $rtoken = $refershtoken->getRefreshToken();
			if($rtoken !== '' && $rtoken !== null){
                SiteConfig::updateOrCreate(
                    ['name' => 'mail_refresh_token'],
                    ['val' => $rtoken, 'status' => 1, 'type' => 'text']
                );
            }
            
            echo '<br />1.AccessToken: ' , $refershtoken->getToken();
            SiteConfig::updateOrCreate(
                ['name' => 'mail_access_token'],
                ['val' => $refershtoken->getToken(), 'status' => 1, 'type' => 'text']
            );
        }
        else{
            if (!isset($_GET['code'])) {
                //If we don't have an authorization code then get one
                $authUrl = $provider->getAuthorizationUrl($options);
                header('Location: ' . $authUrl);
                exit;
                //Check given state against previously stored one to mitigate CSRF attack
            } 
            else {
                if(!empty($_GET['code'])){
                    //Try to get an access token (using the authorization code grant)
                    $token = $provider->getAccessToken(
                        'authorization_code',
                        [
                            'code' => $_GET['code'],
							'access_type'=> 'offline',
							'prompt'=>'consent'
                        ]
                    );
                    //Use this to interact with an API on the users behalf
                    //Use this to get a new access token if the old one expires
                    echo '2.Refresh Token : ', $token->getRefreshToken();
                    SiteConfig::updateOrCreate(
                        ['name' => 'mail_refresh_token'],
                        ['val' => $token->getRefreshToken(), 'status' => 1, 'type' => 'text']
                    );
                    echo '<br />2.AccessToken: ' , $token->getToken();
                    SiteConfig::updateOrCreate(
                        ['name' => 'mail_access_token'],
                        ['val' => $token->getToken(), 'status' => 1, 'type' => 'text']
                    );
                }
            } 
        }
        // Log::info('out function oauth2');
        
    }
}
