<?php

namespace App\Http\Controllers;

use App\BarUserReference;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Stripe\Webhook;
use App\Http\Controllers\Controller;
use App\Subscription;
use Illuminate\Auth\Events\Login;

class StripeWebhookController extends Controller
{
    /**
     * Handle incoming webhook requests from Stripe.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function handleWebhook(Request $request)
    {
        $payload = $request->getContent();
        $sigHeader = $request->server('HTTP_STRIPE_SIGNATURE');
        $event = null;

        try {
            $event = Webhook::constructEvent(
                $payload, $sigHeader, env('STRIPE_WEBHOOK_SIGNATURE')
            );
        } catch (\UnexpectedValueException $e) {
            // Invalid payload
            return response()->json(['error' => 'Invalid payload'], 400);
        } catch (\Stripe\Exception\SignatureVerificationException $e) {
            // Invalid signature
            return response()->json(['error' => 'Invalid signature'], 400);
        }

        // Handle the event
        switch ($event->type) {
            case 'customer.subscription.updated':

                $subscription_id = $event->data->object->id;
                $stripeData = $event->data->object;
                $subscription = Subscription::where('subscription_id',$subscription_id)->latest()->first();

                if($subscription){

                    if($stripeData->cancel_at_period_end == true){
                        $subscription->cancel_at_period_end = 1;
                    }else{
                        $subscription->cancel_at_period_end = 0;
                    }

                    if($subscription->stripe_subscription_status != $stripeData->status){
                        $subscription->stripe_subscription_status = $stripeData->status;
                    }

                    if($subscription->latest_invoice != $stripeData->latest_invoice && $stripeData->cancel_at_period_end != true){

                        $promocode ='';
                        if(!empty($subscriptionResult->discount)){
                            $promocodeData = retrieveStripePromocode($stripeData->discount->promotion_code);
                            $promocode = $promocodeData->code;
                        }

                        $newSubscription = new Subscription();
                        $newSubscription->fill($subscription->toArray());
                        unset($newSubscription->id);
                        $newSubscription->remaining_hours_needed_per_cycle = $subscription->hours_needed_per_cycle;
                        $newSubscription->remaining_general = $subscription->general;
                        $newSubscription->remaining_ethics = $subscription->ethics;
                        $newSubscription->latest_invoice = $stripeData->latest_invoice;
                        $newSubscription->couponcode = !empty($stripeData->discount) ? $stripeData->discount->coupon->name : '';
                        $newSubscription->promocode = $promocode;
                        $newSubscription->start_date = date('Y-m-d H:i:s', $stripeData->current_period_start);
                        $newSubscription->end_date = date('Y-m-d H:i:s', $stripeData->current_period_end);
                        $newSubscription->save();

                        $subscription->stripe_subscription_status = 'expired'; // If subscription Auto renew then we change stripe_subscription_status value to inactive.
                        $subscription->status = 0; // If subscription Auto renew then we change status value to 0.
                    }

                    $subscription->save();
                }else{
                    Log::info('subscription not found', [$event]);
                }
                // Handle successful payment
                break;
            case 'customer.subscription.deleted':
                $subscription_id = $event->data->object->id;
                $stripeData = $event->data->object;
                $subscription = Subscription::where('subscription_id',$subscription_id)->latest()->first();

                if($subscription){
                    if($subscription->stripe_subscription_status != $stripeData->status){
                        $subscription->stripe_subscription_status = $stripeData->status;
                    }
                    $subscription->cancel_at = date('Y-m-d H:i:s', $stripeData->cancel_at);



                    if(!empty($stripeData->cancellation_details) && $stripeData->cancellation_details->comment == "Renew"){
                        $subscription->stripe_subscription_status = "expired";
                        $subscription->status = 0; // cancel based on renewal
                    }else{
                        $barUserReference = BarUserReference::where('id', $subscription->bar_user_references_id)->first();
                        if ($barUserReference) {
                            $barUserReference->update(['is_paid' => 2]);
                        }
                    }
                    $subscription->save();
                }else{
                    Log::info('subscription not found', [$event]);
                }
                break;
            // Handle other event types as needed
        }

        return response()->json(['status' => 'success']);
    }
}
