<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Session\Store;
use Session;
use Carbon\Carbon;
use Cookie;
use App\User;

class SessionTimeout
{
    protected $session;
    protected $timeout = 240; //In minutes

    /**
     * Middleware constructor.
     *
     */
    public function __construct()
    {
        $this->timeout = siteconfig('front_login_lifetime') ?? $this->timeout;
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $authId = \Auth::guard('frontuser')->id();
        if (isset($authId) && !empty($authId) && $authId > 0) {
            if (Session::has('lastActivityTime' . $authId)) {
                $startTime = Carbon::parse(time());
                $finishTime = Carbon::parse(Session::get('lastActivityTime' . $authId));
                if ($startTime->diffInSeconds($finishTime) >= ($this->timeout * 60)) {
                    Session::forget('lastActivityTime' . $authId);
                    \Auth::guard('frontuser')->logout();
                    return redirect(route('home'));
                } else {
                    Session::put('lastActivityTime' . $authId, time());
                }
            } else {
                Session::put('lastActivityTime' . $authId, time());
            }
        }
        return $next($request);
    }
}
