<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Session\Store;
use Session;
use Carbon\Carbon;

class SessionTimeoutAdmin
{
    protected $session;
    protected $timeout = 60;//In minutes
    /**
     * Middleware constructor.
     *
     */
    public function __construct()
    {
        $this->timeout = siteconfig('admin_login_lifetime') ?? $this->timeout;
    }
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (Session::has('lastActivityTimeAdmin')) {
            $startTime = Carbon::parse(time());
            $finishTime = Carbon::parse(Session::get('lastActivityTimeAdmin'));
            if ($startTime->diffInSeconds($finishTime) > ($this->timeout * 60)) {
                if (\Auth::guard('web')->id() > 0) {
                    Session::forget('lastActivityTimeAdmin');
                    \Auth::guard('web')->logout();
                }
            } else {
                Session::put('lastActivityTimeAdmin', time());
            }
        } else {
            Session::put('lastActivityTimeAdmin', time());
        }
        return $next($request);
    }
}
