<?php

namespace App\Http\Middleware;

use Closure;
use App\SiteConfig;

class SetSiteConfig
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (\Schema::hasTable('site_configs')) {
            if (!empty(config('mail.password'))) {
                config([
                    'mail.from.address' => siteconfig('from_email'),
                    'mail.from.name' => siteconfig('from_name'),
                ]);
            } else {
                $accessToken = SiteConfig::where('name', 'mail_access_token')->first();
                if(isset($accessToken)) {
                    config([
                        'mail.from.address' => siteconfig('from_email'),
                        'mail.from.name' => siteconfig('from_name'),
                        'mail.password' => $accessToken->val,
                    ]);
                }
            }
        }
        return $next($request);
    }
}
