<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Route;
use Auth;

class UserRolePermission
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = null)
    {
        if (Auth::guard($guard)->user()->user_type_id == 1) {
            return $next($request);
        }
        if (!canUserAccess(Route::currentRouteName(), Route::current()->parameters(), 'route')) {

            if (Auth::user()->userType->redirect_url !== null) {
            return redirect(Auth::user()->userType->redirect_url);
            }
            abort(401);
        }

        return $next($request);
    }
}
