<?php

namespace App\Http\ViewComposers\Admin;

use App\Menu;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\Auth;
class AdminMenuComposer
{
    public function compose(View $view)
    {
        $menus = Menu::getAdminMenus();
        $menuDetail = [];
        $menu = [];
        if (isset($menus) && count($menus) > 0) {
            foreach ($menus as $menu) {
                $param = (isset($menu['params']) && @unserialize($menu['params']) !== false) ? unserialize($menu['params']) : array();
                if($menu->route_name == 'course-category.index' && $menu->parent_id == 0 && (canUserAccess('course-category-index') || canUserAccess('course-index') || canUserAccess('bundlecourse-index'))){
                      
                }elseif($menu->route_name == 'user.index' && $menu->parent_id == 0){
                    if(canUserAccess('user-list')){
                        $menu->route_name = 'user.index';
                    }
                    else if(canUserAccess('student-list')){
                        $menu->route_name = 'student.list';
                      }
                }
                elseif(Auth::user()->user_type_id != 1 && canUserAccess($menu->route_name,$param,'route') == false){
                    
                    continue;
                }
                $menuDetail[] = array(
                    'id' => $menu['id'],
                    'parent_id' => $menu['parent_id'],
                    'title' => $menu['title'],
                    'url' => route($menu['route_name'],$param),
                    'icon' => $menu['icon'],
                    'imageurl' => asset($menu['imageurl']),
                    'exclude_dashboard' => ($menu['status']) ? true : false,
                    'is_active' => isAdminActiveMenu($menu['route_name'],$param)
                );
            }
            $menu = $this->makeMenu($menuDetail, 0);
            $view->with('menu', $menu);
        }
    }

    function makeMenu($items, $parentId)
    {

        $menu = array_filter($items, function ($item) use ($parentId) {
            return $item['parent_id'] == $parentId;
        });
        foreach ($menu as &$item) {
            $subItems = $this->makeMenu($items, $item['id']);
            if (!empty($subItems)) {
                $item['sub_menu'] = $subItems;
            }
        }
        return $menu;
    }
}
