<?php

namespace App;

use Illuminate\Foundation\Auth\User;
use Illuminate\Support\Facades\DB;
use App\ActivityLog;

class IpTracker extends User
{
    private $dbDateFormat = 'Y-m-d H:i:s';
    private $appConfigVar = 'app.datetime_format';

    /**
     * Define feilds name which are using at CMS
     * Set @var visibleColumns add collection array key name.
     *
     * @var array
     */

    public static $visibleColumns = ["id"=>"", "user"=> "iptracker.user", "ip_address"=> "iptracker.ip_address", "login"=> "iptracker.login_time", "login"=> "iptracker.login_time", "lastactivity"=> "iptracker.last_activity", "logout"=> "iptracker.logout_time"];


    /**
     * Get the user ip and login detail list based on search criteria.
     * @param  \Illuminate\Http\Request  $request
     * @return object App\User
     */
    public function getResult($request,$limitFlag='yes')
    {
        $iptracker = new IpTracker;
        // Search
        $iptrackerCreateAtCond = 'ip_trackers.created_at'; 
        $iptracker = $this->filterIpTracker($request,$iptracker,$iptrackerCreateAtCond);

        if($limitFlag == 'yes'){
            $startPtn = ($request->get('start') != '' && ($request->get('start') != 'NaN')) ? $request->get('start') : 0;
            $limit = $request->get('length') ? $request->get('length'): 100;
            if($limit != -1)
            {
                $iptracker = $iptracker->offset($startPtn)->limit($limit);
            }
        }

        $orderby = $iptrackerCreateAtCond;
        $orderdir = 'desc';
        if(is_array($request->get('order'))){
            $order = $request->get('order');
            $orderby = $order[0]['column'];
            $orderdir = $order[0]['dir'];
            if( $orderby == 0){
                $orderby = 'ip_trackers.created_at';
                $iptracker = $iptracker->orderBy($orderby, $orderdir);
            }
            if($orderby == 1){
                $orderby = 'users.first_name';
                $iptracker = $iptracker->orderBy($orderby, $orderdir)->orderBy('users.last_name', $orderdir);
            }
        }else{
            $iptracker = $iptracker->orderBy($orderby, $orderdir);
        }

        $iptracker = $iptracker->where('activity','login');
        $iptracker = $iptracker->leftJoin('users', 'users.id', '=', 'ip_trackers.user_id');
        $iptracker = $iptracker->leftJoin('user_types', 'users.user_type_id', '=', 'user_types.id');
        $iptracker = $iptracker->select('ip_trackers.id', 'ip_trackers.id','users.id as user_id' , 'ip_trackers.created_at','ip_trackers.activity','ip_trackers.ip_address', 'ip_trackers.created_at as login');
        $iptracker = $iptracker->selectRaw('user_types.title as usertype');
        $iptracker = $iptracker->selectRaw('concat(users.first_name," ",users.last_name) as user');

        $users = $iptracker->get();
        return $this->setUserActivity($users);
    }

    /*
     Mapping array as per the data table
     * @param   $userdata
     * @return object App\User
    */
    private function setUserActivity($users){
        $return = [];
        $i = 0;
        $iptracker = new IpTracker;
        $activitylog = new ActivityLog;
        $mytime = \Carbon\Carbon::now();
        if (!empty($users)) {
            foreach ($users as $user) {
                $next_record = $iptracker->select('activity', 'created_at')->whereRaw('id>?',$user->id)->where('user_id',$user->user_id)->first();

                $logout_date = $iptracker->select('created_at')->where('activity','logout')->where('user_id',$user->user_id)->whereRaw('created_at >=?',$user->created_at->toDateTimeString())->whereRaw('id>?',$user->id)->orderby('created_at', 'asc')->value('created_at');
                $user->logout = (isset($logout_date) && !empty($logout_date))? $logout_date->toDateTimeString() : '';
                if(!empty($next_record) && isset($next_record)){
                    $user->next_name = $next_record->activity;
                    $next_create  = $next_record->created_at;
                    $nextcreate = $next_create->toDateTimeString();
                }
                else{
                    $user->next_name = '';
                    $user->next_create = '';
                }
               
                $selectMaxAct = 'MAX(created_at) as lastactivity';
                $createdAtWhr1 = 'created_at > ?';
                $createdAtWhr2 = 'created_at < ?';
                if($user->next_name == 'login'){
                    $lastactivity = $activitylog->selectRaw($selectMaxAct)->where('user_id',$user->user_id)->whereRaw($createdAtWhr1,$user->created_at->toDateTimeString())->whereRaw($createdAtWhr2, $nextcreate)->value('lastactivity');
                }
                elseif($user->next_name == 'logout'){
                    $lastactivity = $activitylog->selectRaw($selectMaxAct)->where('user_id',$user->user_id)->whereRaw($createdAtWhr1,$user->created_at->toDateTimeString())->whereRaw($createdAtWhr2, $user->logout)->value('lastactivity');
                }
                else{
                    $lastactivity = $activitylog->selectRaw($selectMaxAct)->where('user_id',$user->user_id)->whereRaw($createdAtWhr1,$user->created_at->toDateTimeString())->whereRaw($createdAtWhr2, $mytime->toDateTimeString())->value('lastactivity');
                }
                if(isset($lastactivity) && !empty($lastactivity)){
                    $user->lastactivity = $lastactivity;
                }
                else{
                    $user->lastactivity = '';
                }
                $nestedArr = [];
                $nestedArr[] = $user->login;
                $user1 = $user->user;
                $nestedArr[] = $user1;
                $usertype1 = $user->usertype;
                $nestedArr[] = $usertype1;
                $iptraker1 = $user->ip_address;
                $nestedArr[] = $iptraker1;
                if(!empty($user->login))
                {
                    $loginDateTime =\Carbon\Carbon::createFromFormat($this->dbDateFormat,  $user->login)->format(config($this->appConfigVar));
                }
                else{
                    $loginDateTime = '';
                }
                $nestedArr[] = $loginDateTime;
                $lastactivity = '';
                if(!empty( $user->lastactivity)){
                    $lastactivity = \Carbon\Carbon::createFromFormat($this->dbDateFormat,  $user->lastactivity)->format(config($this->appConfigVar));
                }
                $nestedArr[] = $lastactivity;
                $logoutDateTime = '';
                if(!empty( $user->logout) && ($user->next_name == 'logout')){
                    $logoutDateTime = \Carbon\Carbon::createFromFormat($this->dbDateFormat,  $user->logout)->format(config($this->appConfigVar)) ;
                }
                $nestedArr[] = $logoutDateTime;
                $return[$i] = $nestedArr;
                $i++;
            }
        }
        
        return $return;
    }
    private function filterIpTracker($request,$iptracker,$iptrackerCreateAtCond){
        if (!empty($request->get('search'))) {
            if(is_array($request->get('search'))){
                $searchArr = $request->get('search');
                $searchStr =  $searchArr['value'];
            }
            else{
                $searchStr = $request->get('search');
                $searchStr = addCslashes($searchStr, '\\'); // added for searching backslash issue DLC-140
            }
            $escape = "ESCAPE '|'";
            // added escape for searching backslash issue DLC-140
            $iptracker = $iptracker->where(
                function ($query) use ($searchStr,$escape) {
                    $query
                    ->orWhereRaw('ip_trackers.ip_address LIKE ?  '.$escape, '%'.$searchStr.'%')
                    ->orWhereRaw('users.first_name LIKE ?  '.$escape, '%'.$searchStr.'%')
                    ->orWhereRaw('users.last_name LIKE ?  '.$escape,  '%'.$searchStr.'%')
                    ->orWhereRaw('CONCAT(users.first_name, " ",users.last_name) LIKE ?  '.$escape, '%'.$searchStr.'%');
                }
            );
        }
        $dateStr1 = $dateStr2 = '';
        
        if (!empty($request->get('searchtextDate'))) {
            $dateStr1 = \Carbon\Carbon::parse($request->get('searchtextDate'))->format('Y-m-d 00:00:00') ;
            $dateStr2 = \Carbon\Carbon::parse($request->get('searchtextDate'))->format('Y-m-d 23:59:59') ;
           
            $iptracker = $iptracker->where(
                function ($query) use ($dateStr1,$dateStr2,$iptrackerCreateAtCond) {
                    $query
                    ->where($iptrackerCreateAtCond,'>=', $dateStr1)
                    ->where($iptrackerCreateAtCond,'<=', $dateStr2);
                }
            );
        }

        //filter usertype 
        $usertypeClm = "users.user_type_id";
        if ($request->get('type') !== null) {
            $iptracker = $iptracker->where($usertypeClm,$request->get('type'));
        }
        else{
            $iptracker = $iptracker->whereIn($usertypeClm, ['1','2','3']);
        }
      
        return $iptracker;
    }

}
