<?php

namespace App\Listeners\ActivityLog\Auth;

use Auth;
use App\User;
use App\Listeners\ActivityLog\ActivityLogListener;

class LoginActionListener extends ActivityLogListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return void
     */
    public function handle($event)
    {
        $data = [
            'session_id' => session()->getId(),
            'user_id' => !empty(Auth::id()) ? Auth::id() : 0,
            'pk_id' => $event->user->{$event->user->getKeyName()},
            'model' => $event->user->getTable(),
            'activity' => 'login',
            'data' => [],
            'ip_address' => \Request::getClientIp(true)
        ];

        $this->save($data);
        $this->saveUserLoginData();
    }

    /**
     * Update the login time and ip address in user table
     *
     * @return void
     */
    private function saveUserLoginData()
    {
        $user = User::find(Auth::id());
        $user->last_login_at = \Carbon\Carbon::now()->format('Y-m-d H:i:s');
        $user->last_login_ip = \Request::getClientIp(true);
        $user->save();
    }
}
