<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Traits\DbEvents;

class Member extends Model
{
    use HasFactory , SoftDeletes, DbEvents;
    protected $table = "members";
    
    /**
     * Overwrite created_by field value with currently logged in user.
     * Set @var has_created_by to false if created_by field does not exist in DB Table.
     *
     * @var boolean
     */
    protected $has_created_by = true;

    /**
     * Overwrite updated_by field value with currently logged in user.
     * Set @var has_updated_by to false if created_by field does not exist in DB Table.
     *
     * @var boolean
     */

    protected $has_updated_by = true;

        /**
     * Define feilds name which have html tags
     * Set @var notStripTags add DB Table column name which column have html tags.
     *
     * @var array
     */

     public static $notStripTags = ['description'];

    protected $fillable = [
        'name',
        'description',
        'image',
        'status',
        'created_by',
        'updated_by'
    ];

    protected $appends = ['image_path'];

        /**
     * The get result based on search criteria.
     * @param  \Illuminate\Http\Request  $request
     * @return object App\Page
     */
    public function getResult($request)
    {    
        // Set default parameter values
        $order_by = !empty($request->get('order_by')) ? $request->get('order_by') : 'id';
        $order = !empty($request->get('order')) ? $request->get('order') : 'asc';
        $defaultper_page = !empty($request->get('per_page')) ? $request->get('per_page') : siteconfig('records_per_page', 0);

        // Fetch pages list
        $pages = new Member();

        // Search
        if (!empty($request->get('search'))) {
            $searchStr = $request->get('search');
            $escape = "ESCAPE '|'";
             if(substr_count($searchStr,"|")){
                $searchStr = str_replace('\\', '\\\\\\', $searchStr);
                 $escape = "";
             }
            // added escape for searching backslash issue DLC-140
            $pages = $pages->where(function ($query) use ($searchStr,$escape) {
                $query
                ->whereRaw('name LIKE ?  '.$escape, '%'.$searchStr.'%')
                ->orWhereRaw('description LIKE ?  '.$escape, '%'.$searchStr.'%');
            });
        }

        // Status
        if ($request->get('status') !== null) {
            $pages = $pages->where('status', $request->get('status'));
        }
        //if per_page not set then all record value use for per_page
        // Curretly it is not in Admin user listing as we are using data table paging
        // but have kept this for API integration
        $per_page = !empty($defaultper_page) ? $defaultper_page : $pages->count();

        // Order By & Pagination
        $pages = $pages->orderBy($order_by, $order)->paginate($per_page);

        return $pages;
    }

    public function getImagePathAttribute()
    {
        return getImageUrlForModule($this->image, 'members','','member');
    }
}
