<?php

namespace App;

use App\Page;
use Illuminate\Database\Eloquent\Model;

class Menu extends Model
{
    /**
    * Define feilds name which have html tags
    * Set @var notStripTags add DB Table column name which column have html tags.
    *
    * @var array
    */

    /**
     * Overwrite created_by field value with currently logged in user.
     * Set @var has_created_by to false if created_by field does not exist in DB Table.
     *
     * @var boolean
     */
    protected $has_created_by = true;

    /**
     * Overwrite updated_by field value with currently logged in user.
     * Set @var has_updated_by to false if created_by field does not exist in DB Table.
     *
     * @var boolean
     */

    protected $fillable = [
        'title',
        'route_name',
        'params',
        'type',
        'parent_id',
        'status',
        'created_by',
        'updated_by'
    ];

    protected $has_updated_by = true;

    public static $notStripTags = [];

    public static function getPages()
    {
        // Find out existing pages based on slug.
        return Page::select('slug', 'title')->where('status', 1)->orderBy("title")->get();
    }

    public static function getFrontMenus()
    {
        return Menu::select('id', 'title', 'route_name', 'params', 'icon', 'imageurl', 'parent_id')->where('type', 'Front')->whereNull('deleted_at')->where('status', 1)->orderBy("display_order")->get();
    }

    public static function getAdminMenus()
    {
        return Menu::select('id', 'title', 'route_name', 'params', 'icon', 'imageurl', 'parent_id')->where('type', 'Admin')->whereNull('deleted_at')->where('status', 1)->orderBy("display_order")->get();
    }
}
