<?php

namespace App;

use SoftDeletes;
use App\Traits\DbEvents;
use Illuminate\Database\Eloquent\Model as BaseModel ;

use App\Help;
use App\CategoryReference;

class Model extends BaseModel
{
    use SoftDeletes, DbEvents;

    public static function getTableName()
    {
        return with(new static)->getTable();
    }

    /** Override Model Save method
    *
    * @param  array  $options
    * @return bool
    */
    public function save(array $options = [])
    {
        $tablename = $this->getTableName();
        if (isset($this->display_order) && !empty($this->display_order) && empty($this->id) && !in_array($tablename,['surveys_questions_xrefs','survey_submits_questions'])) {
            $this->display_order = \DB::raw('(SELECT x.* FROM ((SELECT IF(MAX(display_order) > 0, MAX(display_order) + 1, 1) as display_order FROM '. $tablename.' WHERE `deleted_at` is null)) x )');
        }
        // before save code
        parent::save($options);
        // after save code
        $requestData = request()->all();

        if ($tablename == 'help_messages' && isset($requestData['help_id']) && $requestData['help_id'] > 0 ){
              Help::where('id', $requestData['help_id'])->update(['updated_at' => \Carbon\Carbon::now()]);
        }

         //save category reference data if category id exist
         $item = $this;
         $itemCls = get_class($item) ;
         if (!empty($requestData) && isset($requestData['parent_category']) && $itemCls != 'App\\CategoryReference') {

             $categoryRefereceObj = new CategoryReference;

             $data['ref_type'] =  $itemCls;
             $data['ref_id'] =  $item->id;
             $data['category_id'] = $requestData['parent_category'];
             $existing_ref = $categoryRefereceObj->where('ref_type',  $itemCls)->where('ref_id', $item->id)->get();
             if ($existing_ref->count() > 0) {
                 $categoryRefereceObj->where('ref_id', $item->id)->where('ref_type',  $itemCls)->update(['category_id' => $data['category_id']]);
             } else {
                 $categoryRefereceObj->fill($data);
                 $categoryRefereceObj->save();
             }
             // Save the Data
         }
         //save category reference data if category id exist
    }

    /**
     * Override Model Delete method
     *
     * @return bool|null
     *
     * @throws \Exception
     */
    public function delete()
    {
        $item = $this;

        parent::delete();

       //remove category reference data
       $itemCls = get_class($item) ;
        if(optional($item->categoryReferences)->count()){
            $categoryRefereceObj = new CategoryReference;
            $categoryRefereceObj = $categoryRefereceObj->where('ref_id',$item->id)->where('ref_type',$itemCls)->delete();
        }
    }

}
