<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ConnectedSpeakerToPodcastNotification extends Notification
{
    use Queueable;

    // public $attachment;
    public $content, $faculty, $activeSpeakerNames, $contentLength;
    /**
     * Create a new notification instance.
     */
    public function __construct($faculty, $content, $activeSpeakerNames, $contentLength)
    {
        // $this->attachment = $attachment;
        $this->faculty = $faculty;
        $this->content = $content;
        $this->activeSpeakerNames = $activeSpeakerNames;
        $this->contentLength = $contentLength;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Your podcast has just gone LIVE!')
            ->salutation("The CLEarly Legal Team")
            ->markdown('email.admin.podcastspeakeremail',['content'=>$this->content, 'faculty'=>$this->faculty, 'activeSpeakerNames'=>$this->activeSpeakerNames, 'contentLength'=>$this->contentLength]);

    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }

}

