<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class FirmUserVerification extends Notification
{
    use Queueable;

    /**
     * The password reset/account verification token.
     *
     * @var string
     */
    public $user, $firm, $firm_admin;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($user, $firm, $firm_admin)
    {
        $this->user = $user;
        $this->firm = $firm;
        $this->firm_admin = $firm_admin;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('New User Request for Approval and Payment '. $this->user->fullname)
            ->markdown('email.front.firmuserverification', ['user' => $this->user,'firm' => $this->firm, 'firm_admin' => $this->firm_admin]);
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
