<?php

namespace App\Notifications;

use Illuminate\Support\Facades\Lang;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class FrontFirmUserVerification extends Notification
{
    use Queueable;

    /**
     * The password reset/account verification token.
     *
     * @var string
     */
    public $token, $firmname;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($token, $firmname)
    {
        $this->token = $token;
        $this->firmname = $firmname;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Activate Your Account on '.Lang::get(siteconfig('app_name')))
            ->markdown('email.front.frontfirmuseractivationlink', ['user' => $notifiable,'firmname'=> $this->firmname,'domain' => url(''),'veryfy_link'=>url(config('app.url').route('user.mail_verification', ['token' => $this->token, 'email' => $notifiable->getEmailForPasswordReset()], false))]);
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
