<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Support\Facades\Lang;

class FrontUserSecurityCode extends Notification
{
    use Queueable;

     /**
     * The password reset/account verification token.
     *
     * @var string
     */
    public $securityCode;
    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($securityCode)
    {
        $this->securityCode = $securityCode;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
        ->subject(siteconfig('company_name').' - Security Code Verification')
        ->salutation("The CLEarly Legal Team")
        ->markdown('email.admin.securitycode', ['user' => $notifiable,'domain' => url(''), 'securityCode' => $this->securityCode]);
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
