<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class RejectFirmUserStatus extends Notification
{
    use Queueable;

    /**
     * The password reset/account verification token.
     *
     * @var string
     */
    public $user, $firm;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($user, $firm)
    {
        $this->user = $user;
        $this->firm = $firm;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject($this->firm->name." Membership Request Update")
            ->markdown('email.front.userfirmstatus.reject', ['user' => $this->user,'firm' => $this->firm]);
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
