<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class SendApprovedSubmissions extends Notification
{
    use Queueable;

    // public $attachment;
    public $submissions;
    public $approved_credits;
    /**
     * Create a new notification instance.
     */
    public function __construct($submissions, $approved_credits)
    {
        // $this->attachment = $attachment;
        $this->submissions = $submissions;
        $this->approved_credits = $approved_credits;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Your Podcast Submissions Have Been Approved')
            ->salutation("CLEarly Legal")
            ->markdown('email.admin.submissionapproved', ['submissions'=>$this->submissions, 'user'=>$notifiable, 'approved_credits'=>$this->approved_credits]);
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
