<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class SendBetaUsersTestingEmail extends Notification
{
    use Queueable;

    // public $attachment;
    public $name;
    /**
     * Create a new notification instance.
     */
    public function __construct($name)
    {
        // $this->attachment = $attachment;
        $this->name = $name;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('CLE-by-Podcast Beta Testing – Thank You for Your Support!')
            ->salutation("Thank you")
            ->markdown('email.admin.newPromoCodeSend',['name'=>$this->name]);
            // ->attach($this->attachment);
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
