<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class SendCertificate extends Notification
{
    use Queueable;

    public $attachment;

    /**
     * Create a new notification instance.
     */
    public function __construct($attachment)
    {
        $this->attachment = $attachment;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
                    ->subject('Clearly Legal - Certificate')
                    ->salutation("The CLEarly Legal Team")
                    ->markdown('email.admin.sendcertificate',[])
                    ->attachData($this->attachment, 'certificate.pdf', [
                        'mime' => 'application/pdf',
                    ]);
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
