<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class SendMonthlySubscriptionSummaryReport extends Notification
{
    use Queueable;

    public $subscriptions;

    /**
     * Create a new notification instance.
     */
    public function __construct($subscriptions)
    {
        $this->subscriptions = $subscriptions;

    }
    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
                ->subject('Monthly Report: Activated Users')
                ->salutation("The CLEarly Legal Team")
                ->markdown('email.admin.sendmonthlysubscriptionsummary', ['subscriptions'=>$this->subscriptions]);
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
