<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class SendSubmissionReports extends Notification implements ShouldQueue
{
    use Queueable;

    // public $attachment;
    public $count, $userHoursData;
    /**
     * Create a new notification instance.
     */
    public function __construct($count, $userHoursData)
    {
        // $this->attachment = $attachment;
        $this->count = $count;
        $this->userHoursData = $userHoursData;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Daily Report: Completed Credit Submissions')
            ->salutation("The CLEarly Legal Team")

            ->markdown('email.admin.sendsubmissionreport',['count'=>$this->count, 'userHoursData'=>$this->userHoursData]);

            // ->attach($this->attachment);
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
