<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Support\Facades\Lang;

class SendUserActivationEmailToAdmin extends Notification
{
    use Queueable;
    private $user, $subscription, $subtotal, $total, $discount, $is_discount_percentage;

    /**
     * Create a new notification instance.
     */
    public function __construct($user, $subscription)
    {
        $this->user = $user;
        $this->subscription = $subscription;

        // Calculate subtotal
        $this->subtotal = 0;
        foreach ($this->subscription->items->data as $item) {
            $this->subtotal += $item->price->unit_amount * $item->quantity;
        }

        // Calculate total, considering discounts
        $this->total = $this->subtotal;

        // Check if there are any discounts applied and adjust the total
        if ($this->subscription->discount) {
            $discount = $this->subscription->discount->coupon->percent_off ?: $this->subscription->discount->coupon->amount_off;
            $this->is_discount_percentage = $this->subscription->discount->coupon->percent_off == null ? 0 : 1 ;
            // Assume the discount is a percentage or fixed amount
            // If it's a fixed discount (e.g., 10 USD off), subtract it
            if ($this->subscription->discount->coupon->amount_off) {
                $this->discount = $this->subscription->discount->coupon->amount_off;
                $this->total -= $this->subscription->discount->coupon->amount_off;
            }
            // If it's a percentage discount (e.g., 10% off), apply it
            if ($this->subscription->discount->coupon->percent_off) {
                $this->discount = $this->subtotal * ($discount / 100);
                $this->total -= ($this->subtotal * ($this->subscription->discount->coupon->percent_off / 100));
            }
        }
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject(siteconfig('site_title') . ' - ' . Lang::get('User Activated'))
            ->salutation("The CLEarly Legal Team")
            ->markdown('email.admin.sendaccountactivatedemailtoadmin', [
                'user' => $this->user,
                'subscription' => $this->subscription,
                'subtotal' => $this->subtotal,
                'total' => $this->total,
                'discount'=>$this->discount,
                'is_discount_percentage'=>$this->is_discount_percentage,
            ]);
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
