<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class SendWeeklySummaryReport extends Notification
{
    use Queueable;

    public $podcastsCL, $podcastYetToSubmit, $credits_earned, $latestPodcasts;

    /**
     * Create a new notification instance.
     */
    public function __construct($podcastsCL, $podcastYetToSubmit, $credits_earned, $latestPodcasts)
    {
        $this->podcastsCL = $podcastsCL;
        $this->podcastYetToSubmit = $podcastYetToSubmit;
        $this->credits_earned = $credits_earned;
        $this->latestPodcasts = $latestPodcasts;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
                ->subject('Your Weekly Podcast Activity and CLE Summary')
                ->salutation("The CLEarly Legal Team")
                ->markdown('email.weeklysummary', ['podcastsCL'=>$this->podcastsCL, 'podcastYetToSubmit'=>$this->podcastYetToSubmit, 'credits_earned'=>$this->credits_earned, 'user'=>$notifiable, 'latestPodcasts'=>$this->latestPodcasts]);
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
