<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Support\Facades\Lang;
class SentInvoice extends Notification
{
    use Queueable;

    private $user,$invoiceData;
    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($user,$invoiceData)
    {
        $this->user = $user;
        $this->invoiceData = $invoiceData;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject(siteconfig('site_title') . ' - ' . Lang::get('Account Access'))
            ->salutation("The CLEarly Legal Team")
            ->markdown('email.invoice', ['user' => $this->user,'invoiceData' => $this->invoiceData]);
    }
    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
