<?php

namespace App\Observers;

use App\Content;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;

class ContentObserver
{
    /**
     * Handle the Content "created" event.
     */
    public function created(Content $content): void
    {
        Cache::forget('rss.feed');
    }

    /**
     * Handle the Content "updated" event.
     */
    public function updated(Content $content): void
    {
        Cache::forget('rss.feed');
        
    }

    /**
     * Handle the Content "deleted" event.
     */
    public function deleted(Content $content): void
    {
        Cache::forget('rss.feed');
    }

    /**
     * Handle the Content "restored" event.
     */
    public function restored(Content $content): void
    {
        //
    }

    /**
     * Handle the Content "force deleted" event.
     */
    public function forceDeleted(Content $content): void
    {
        //
    }
}
