<?php
namespace App\Overrides;

use Illuminate\Mail\TransportManager as BaseTransportManager;
use Illuminate\Support\Facades\Log;
use PHPMailer\PHPMailer\OAuth;
//Alias the League Google OAuth2 provider class
use League\OAuth2\Client\Provider\Google;
use App\SiteConfig;
use Swift_SmtpTransport as SmtpTransport;

class CustomTransportManager extends BaseTransportManager
{
    // Override any of the methods as needed
    // For example, you could override the createSmtpDriver method:
    protected function createSmtpDriver()
    {
        $transport = parent::createSmtpDriver();
        $config = $this->app->make('config')->get('mail');

        if (isset($config['authmode'])) {
            $transport->setAuthMode($config['authmode']);
        }

        return $transport;
    }

}
