<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class PodcastRefSpeakers extends Model
{
    use HasFactory;

    protected $table = "podcast_ref_speakers"; 
    protected $fillable = [
        'podcast_id',
        'speaker_id'
    ];

    public function podcast($id){
        $podcast = Content::where('id',$id)->with('contentFiles','speakers')->firstOrFail();

        if ($podcast->status == 1 && (is_null($podcast->expire_date) || Carbon::parse($podcast->expire_date)->gte(Carbon::now()))){ 
            $contentsData = (object)[
                'id'=>$podcast->id,
                'podcast_title' => $podcast->podcast_title,
                'title_crc32' => $podcast->title_crc32,
                'cl_type' => $podcast->cl_type,
                'category'=> $podcast->category->name,
                'created_at' => $podcast->created_at,
                'image_path' => $podcast->image_path,
                'image_alt' => $podcast->image_alt,
                'provider_name' => $podcast->provider_name,
                'status'=>$podcast->status,
                'short_description'=>$podcast->short_description,
                'published_on'=>$podcast->published_on,
                'contentFiles' => $podcast->contentFiles->map(function ($file) {
                    return (object)[
                            'id'=>$file->id,
                            'contents_id'=>$file->contents_id,
                            'length' => $file->length,
                            'credit' => $file->credit,
                            'credit_earned' => $file->credit_earned,
                            'view_counts' => $file->view_counts,
                            'file'=>$file->file,
                            'file_name'=>$file->file_name,
                            'file_path'=>$file->file_path,
                            'last_listen_time_in_seconds'=>$file->last_listen_time_in_seconds,
                            'created_at'=>$file->created_at,
                            'status' => $file->status,
                    ];
                }),
                'speakers' => $podcast->speakers_name,
                'lengthOfPodcast' => $podcast->lengthOfPodcast(),
                'totalCreditsOfPodcast'=> $podcast->totalCreditsOfPodcast('Tennessee'),

            ];
    
            return $contentsData;
        }
    }

    public function podcastForApi($id){
        $podcast = Content::where('id', $id)
            ->with('contentFiles.contentStates', 'speakers', 'category')
            ->firstOrFail();
    
        $filteredContentFiles = [];

        if (
            $podcast->status == 1 &&
            (is_null($podcast->expire_date) || Carbon::parse($podcast->expire_date)->gte(Carbon::now()))
        ) {
            if (Auth::check()) {
                $user = Auth::user();
                $user_bar_ids = $user->getUserBarIds()->toArray();
                $contentFiles = $podcast->contentFiles->all();
    
                foreach ($contentFiles as $file) {
                    $states = $file->contentStates->all();
                    foreach ($states as $state) {
                        if (in_array($state->bar_id, $user_bar_ids)) {
                            $filteredContentFiles[] = (object)[
                                'id' => $file->id,
                                'contents_id' => $file->contents_id,
                                'length' => $file->length,
                                'credit' => $file->credit,
                                'credit_earned' => $file->credit_earned,
                                'view_counts' => $file->view_counts,
                                'file' => $file->file,
                                'file_name' => $file->file_name,
                                'file_path' => $file->file_path,
                                'last_listen_time_in_seconds' => $file->last_listen_time_in_seconds,
                                'created_at' => $file->created_at,
                                'status' => $file->status,
                            ];
                            break;
                        }
                    }
                }
            }
    
            if (!empty($filteredContentFiles)) {
                $contentsData = (object) [
                    'id' => $podcast->id,
                    'podcast_title' => $podcast->podcast_title,
                    'cl_type' => $podcast->cl_type,
                    'category' => $podcast->category->name,
                    'created_at' => $podcast->created_at,
                    'image_path' => $podcast->image_path,
                    'image_alt' => $podcast->image_alt,
                    'provider_name' => $podcast->provider_name,
                    'status' => $podcast->status,
                    'short_description' => $podcast->short_description,
                    'published_on' => $podcast->published_on,
                    'contentFiles' => array_values($filteredContentFiles),
                    'speakers' => $podcast->speakers
                        ->filter(function ($speaker) {
                            return $speaker->speaker?->status == 1;
                        })
                        ->map(function ($speaker) {
                            return $speaker->speaker->name;
                        }),
                ];
    
                return $contentsData;
            }
        }
    
        return null; // Return null explicitly if no contentsData was returned
    }

    public function speaker(){
        return $this->belongsTo(Faculty::class, 'speaker_id', 'id');
    }

}
