<?php

namespace App;

use App\Traits\DbEvents;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;

class Provider extends Model
{

    use HasApiTokens,Notifiable, SoftDeletes, DbEvents;

    protected $table = "provider_users";
    /**
     * Overwrite created_by field value with currently logged in user.
     * Set @var has_created_by to false if created_by field does not exist in DB Table.
     *
     * @var boolean
     */
    protected $has_created_by = true;

    /**
     * Overwrite updated_by field value with currently logged in user.
     * Set @var has_updated_by to false if created_by field does not exist in DB Table.
     *
     * @var boolean
     */

    protected $has_updated_by = true;

    protected $fillable = [
        'name',
        'user_type',
        'status',
        'created_by',
        'updated_by'
    ];

    function getProvidersList($request){
        $providerList =  Provider::where('status',1)->where('user_type',$request->user_type)->pluck('id','name')->flip();
        $providerList->put('other', __('content.addOtherProvider'));

        return $providerList;
    }
}
