<?php

namespace App\Providers;

use App\Content;
use App\Observers\ContentObserver;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Validator;


class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // Set max execution time to zero to avoid max execution time error.
        ini_set('max_execution_time', '0');
        ini_set('post_max_size', '1024M');;
        ini_set('upload_max_filesize', '1024M');
        // Log::info(phpinfo());

        // Set Default String Length to avoid length error
        Schema::defaultStringLength(255);
        Validator::extend('array_required_if', function ($attribute, $value, $parameters, $validator) {
            $otherField = $parameters[0];
            $otherValue = $parameters[1];
            if ($validator->getData()[$otherField] === $otherValue) {
                return !in_array(null, $value, true) && count($value) >= 2;
            }  
            return true;        
        });
        Validator::extend('enable_require_no', function ($attribute, $value, $parameters, $validator) {
            // Get the value of the other field (assumed to be named "other_field")
            $otherFieldValue = $validator->getData()['payment_before_enrollment'];
            // Check if the current field value is "yes" and the other field value is "no"  
            if ($value === 'Enable' && $otherFieldValue == 0) {
                return true; 
            }  
            else if($value === 'Enable' && $otherFieldValue == 1){
                return false; 
            }
            return true;      
        });

        Content::observe(ContentObserver::class);
    }
}
