<?php

namespace App\Providers;

use Laravel\Passport\Passport;
use Illuminate\Support\Facades\Gate;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Carbon\Carbon;
use Exception;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array
     */
    protected $policies = [
       //  'App\Model' => 'App\Policies\ModelPolicy',
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerPolicies();

        try {
            $api_access_token_lifetime= !empty(siteconfig('api_access_token_lifetime')) ? (siteconfig('api_access_token_lifetime') * 60) : '86400'; //default 30 minutes
            $api_refresh_token_lifetime= !empty(siteconfig('api_refresh_token_lifetime')) ? (siteconfig('api_refresh_token_lifetime') * 60) : '86400'; //default 90 minutes
        }
        catch(Exception $e) {
            $api_access_token_lifetime= '86400'; //default 30 minutes
            $api_refresh_token_lifetime= '86400'; //default 90 minutes
        }

        Passport::tokensExpireIn(now()->addSeconds($api_access_token_lifetime));
        Passport::refreshTokensExpireIn(now()->addSeconds($api_refresh_token_lifetime));
    }
}
