<?php

namespace App\Providers;

use App\Overrides\CustomTransportManager;
use Illuminate\Mail\MailServiceProvider;
use Illuminate\Support\Facades\Log;

class MyMailServiceProvider extends MailServiceProvider
{
    /**
     * Register the transport manager instance.
     *
     * @return void
     */

    public function registerSwiftTransport()
    {
        $this->app->singleton('swift.transport', function ($app) {
            return new CustomTransportManager($app);
        });
    }

}
