<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Validator;

class ValidatorServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        // Google Captcha Validation
        Validator::extend('recaptcha', 'App\Validators\ReCaptcha@validate');

        // Email Array Validation
        Validator::extend('email_array', 'App\Validators\EmailArray@validate'); 
    }
}
