<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QREvents extends Model
{
    use HasFactory;

    protected $table = "qrcode_events";

    protected $fillable =[
        'uuid',
        'event_name',
        'description',
        'qr_endpoint',
        'status',
        'created_by',
        'updated_by',
    ];

    public function getRouteKeyName()
{
    return 'uuid';
}
    public function qrStatistics(){
        return $this->hasMany(QRStatistics::class, 'event_id');
    }

    public function qrScanTotalAttempts(){
        return $this->qrStatistics()->sum('scan_attempts');
    }

    public function getResult($request)
    {    
        // Set default parameter values
        $order_by = !empty($request->get('order_by')) ? $request->get('order_by') : 'id';
        $order = !empty($request->get('order')) ? $request->get('order') : 'asc';
        $defaultper_page = !empty($request->get('per_page')) ? $request->get('per_page') : siteconfig('records_per_page', 0);

        // Fetch pages list
        $pages = new QREvents();

        // Search
        if (!empty($request->get('search'))) {
            $searchStr = $request->get('search');
            $escape = "ESCAPE '|'";
             if(substr_count($searchStr,"|")){
                $searchStr = str_replace('\\', '\\\\\\', $searchStr);
                 $escape = "";
             }
            // added escape for searching backslash issue DLC-140
            $pages = $pages->where(function ($query) use ($searchStr,$escape) {
                $query
                ->whereRaw('event_name LIKE ?  '.$escape, '%'.$searchStr.'%');
            });
        }

        // Status
        if ($request->get('status') !== null) {
            $pages = $pages->where('status', $request->get('status'));
        }
        //if per_page not set then all record value use for per_page
        // Curretly it is not in Admin user listing as we are using data table paging
        // but have kept this for API integration
        $per_page = !empty($defaultper_page) ? $defaultper_page : $pages->count();

        // Order By & Pagination
        $pages = $pages->orderBy($order_by, $order)->paginate($per_page);

        return $pages;
    }


}
