<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Facades\DB;

class CaseSensitiveExists implements Rule
{
    protected $table;
    protected $column;
    protected $activeColumn;
    protected $deletedColumn;

    /**
     * Create a new rule instance.
     *
     * @param  string  $table
     * @param  string  $column
     * @return void
     */
    public function __construct($table, $column, $activeColumn = 'status', $deletedColumn = 'deleted_at')
    {
        $this->table = $table;
        $this->column = $column;
        $this->activeColumn = $activeColumn;
        $this->deletedColumn = $deletedColumn;
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        return DB::table($this->table)
            ->whereRaw("BINARY `{$this->column}` = ?", [$value])
            ->where($this->activeColumn, 1)
            ->whereNull($this->deletedColumn)
            ->exists();
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'Invalid :attribute. Please check with your firm admin to provide you with the correct one.';
    }
}

