<?php

namespace App;

use App\Model;
use Auth;
use Exception;

class Support extends Model
{
    protected $table = "support";
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id',
        'firm_name',
        'firstName',
        'lastName',
        'phone',
        'email',
        'comment',
    ];


    /**
     * The get result based on search criteria.
     * @param  \Illuminate\Http\Request  $request
     * @return object App\Support
     */
    public function getResult($request)
    {
        // Set default parameter values
        $order_by = !empty($request->get('order_by')) ? $request->get('order_by') : 'created_at';
        $order = !empty($request->get('order')) ? $request->get('order') : 'desc';

        // Fetch ContactUs list
        $supports = new Support;

        // Search
        if (!empty($request->get('search'))) {
            $searchStr = $request->get('search');
            $escape = "ESCAPE '|'";
             if(substr_count($searchStr,"|")){
                $searchStr = str_replace('\\', '\\\\\\', $searchStr);
                 $escape = "";
             }
            $nameParts = explode(' ', $searchStr);
            // added escape for searching backslash issue DLC-140
            $supports = $supports->where(function ($query) use ($searchStr,$escape,$nameParts) {
                $query
                ->where(function ($innerQuery) use ($searchStr, $escape,$nameParts) {
                    foreach ($nameParts as $part) {
                        $innerQuery->orWhere(function ($q) use ($part, $escape) {
                            $q->whereRaw('firstName LIKE ? '. $escape, '%' . $part . '%')
                              ->orWhereRaw('lastName LIKE ? '. $escape, '%' . $part . '%');
                        });
                    }
                })
                ->orWhereRaw('phone LIKE ? '.$escape, '%'.$searchStr.'%')
                ->orWhereRaw('email LIKE ? '.$escape, '%'.$searchStr.'%');
            });
        }


        //if per_supports not set then all record value use for per_supports
        // Curretly it is not in Admin user listing as we are using data table paging
        // but have kept this for API integration
        $per_supports = !empty($request->get('per_page')) ? $request->get('per_page') : $supports->count();

        // Order By & Pagination
        $supports = $supports->orderBy($order_by, $order)->paginate($per_supports);

        return $supports;
    }


}
