<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Model;
class UserCredits extends Model
{
    use HasFactory;
    /**
     * Overwrite created_by field value with currently logged in user.
     * Set @var has_created_by to false if created_by field does not exist in DB Table.
     *
     * @var boolean
     */
    protected $has_created_by = true;

    /**
     * Overwrite updated_by field value with currently logged in user.
     * Set @var has_updated_by to false if created_by field does not exist in DB Table.
     *
     * @var boolean
     */

    protected $has_updated_by = true;

    /**
     * Define feilds name which have html tags
     * Set @var notStripTags add DB Table column name which column have html tags.
     *
     * @var array
     */

    public static $notStripTags = [];

    protected $appends = ['content_name', 'content_file_name', 'image_path','provider_name'];
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id',
        'content_id',
        'content_file_id',
        'content_state_id',
        'content_listeners_id',
        'credit_for',
        'credit',
        'submission_id',
        'subscription_id',
        'stripe_subscription_id',
        'created_by',
        'updated_by'
    ];

    public function contentsState()
    {
        return $this->belongsTo(ContentsStates::class, 'content_state_id', 'id');
    }

    public function getContentNameAttribute()
    {
        $content = $this->belongsTo(Content::class, 'content_id', 'id')->first();
        return $content ? $content->podcast_title : null;
    }

    public function getImagePathAttribute()
    {
        $content = $this->belongsTo(Content::class, 'content_id', 'id')->first();
        return $content ? $content->image_path : null;
    }

    public function getContentFileNameAttribute()
    {
        $content_file = $this->belongsTo(ContentFiles::class, 'content_file_id', 'id')->first();
        return $content_file ? $content_file->file_name : null;
    }
    public function getProviderNameAttribute()
    {
        $content = $this->belongsTo(Content::class, 'content_id', 'id')->first();
        return $content ? $content->provider_name : null;
    }
}
