<?php

use App\Bar;
use App\BarUserReference;
use App\Category;
use App\ContentFiles;
use App\Firm;
use App\Notifications\SendSubmissionReports;
use App\Notifications\SentInvoice;
use App\Submissions;
use App\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Google\Cloud\SecretManager\V1\SecretManagerServiceClient;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Route;
use Spatie\PdfToImage\Exceptions\PdfDoesNotExist;

define('IMAGE_SIZES', 'image-sizes.');
define('SIZES', '.sizes');
if (!function_exists('siteconfig')) {

    /**
     * Get a site config value
     *
     * @param $key
     * @param null $default
     * @return bool|int|mixed
     */
    function siteconfig($key, $default = null)
    {
        if (is_null($key)) {
            return new \App\SiteConfig();
        }

        $value = \App\SiteConfig::get($key);
        return is_null($value) ? value($default) : $value;
    }
}

if (!function_exists('getPerPageOptions')) {
    /**
     * Get per page options
     *
     * @return array
     */

    function getPerPageOptions()
    {
        return \App\SiteConfig::getDefinedSiteConfigFields(0)->where('name', 'records_per_page')->pluck('options')->last();
    }
}

if (!function_exists('prepareInputRequestArray')) {
    /**
     * Prepare Input Request Array
     *
     * @param array $param
     * @return array
     */

    function prepareInputRequestArray($param = [])
    {
        $input_fields = ['per_page', 'search', 'search_referrer', 'status', 'order_by', 'order'];
        $input = Illuminate\Support\Facades\Request::only($input_fields);


        if (!empty($param)) {
            foreach ($param as $name => $value) {
                $input[$name] = $value;
            }
        }

        return $input;
    }
}

// if (!function_exists('addOrderByCSSClass')) {
//     /**
//      * Add css class when order by applied on specific fiel
//      *
//      * @param string $field
//      * @return string
//      */
//     function addOrderByCSSClass($field)
//     {
//         if ($field == Request::get('order_by')) {
//             return Request::get('order') == 'asc' ? 'icon-keyboard_arrow_up' : 'icon-keyboard_arrow_down';
//         }
//         return 'icon-unfold_more';
//     }
// }

if (!function_exists('getImageUrl')) {
    /**
     * Get image url by specific dimention
     *
     * @param string $image
     * @param string $size
     * @return string
     */
    function getImageUrl($image, $folder = 'uploads', $size = '')
    {
        if ($image == null || $image == '') {
            return asset('assets/common/images/podcast_placeholder_square.svg');
        }
        if (!empty($size)) {
            return getMediaUrl($folder . '/' . $size . '-' . $image, config(IMAGE_SIZES . $folder . '.visibility'));
        } else {
            return getMediaUrl($folder . '/' . $image, config(IMAGE_SIZES . $folder . '.visibility'));
        }
    }
}


if (!function_exists('getImageUrlForModule')) {
    /**
     * Get image url by specific dimention
     *
     * @param string $image
     * @param string $size
     * @return string
     */
    function getImageUrlForModule($image, $folder = 'uploads', $size = '', $module=null)
    {
        if (($image == null || $image == '') && $module != null) {

            switch ($module) {
                case 'faculty':
                    return asset('assets/common/images/user_placeholder.png');
                    break;
                case 'member':
                    return asset('assets/common/images/user_placeholder.png');
                    break;
                case 'news':
                    return asset('assets/common/images/cl_grey_placeholder.png');
                    break;
                case 'release':
                    return asset('assets/common/images/cl_grey_placeholder.png');
                    break;
                default:
                return asset('assets/common/images/podcast_placeholder_square.svg');
                    break;
            }
        }
        if (!empty($size)) {
            return getMediaUrl($folder . '/' . $size . '-' . $image, config(IMAGE_SIZES . $folder . '.visibility'));
        } else {
            return getMediaUrl($folder . '/' . $image, config(IMAGE_SIZES . $folder . '.visibility'));
        }
    }
}

// if (!function_exists('getDocumentUrl')) {
//     /**
//      * Get image url by specific dimention
//      *
//      * @param string $image
//      * @param string $size
//      * @return string
//      */
//     function getDocumentUrl($image, $folder = 'uploads')
//     {
//         return getMediaUrl($folder . '/' . $image, config(IMAGE_SIZES . $folder . '.visibility'));
//     }
// }

// if (!function_exists('isMediaExist')) {
//     /**
//      * Check is media file exist on the storage
//      *
//      * @param string $media
//      * @param string $folder
//      */
//     function isMediaExist($media, $folder = 'uploads', $size = '')
//     {
//         if (!empty($size) && Storage::exists($folder . '/' . $size . '-' . $media) || empty($size) && Storage::exists($folder . '/' . $media)) {
//             return true;
//         }
//         return false;
//     }
// }

if (!function_exists('getMediaUrl')) {
    /**
     * Get temporary url for private media
     *
     * @param string $file
     */
    function getMediaUrl($file, $visibility = '')
    {
        $visibility = getMediaVisibility($visibility);
        if ($visibility == 'private') {
            return Storage::temporaryUrl(
                $file,
                now()->addMinutes(15)
            );
        } else {
            return Storage::url($file);
        }
    }
}

if (!function_exists('getMediaVisibility')) {
    /**
     * Get media visibility
     *
     * @param string $visibility
     */
    function getMediaVisibility($visibility = '')
    {
        $visibility = empty($visibility) ? config('filesystems.visibility') : $visibility;
        if (in_array(config('filesystems.default'), ['local', 'public'])) {
            return 'public';
        } else {
            return $visibility;
        }
    }
}


if (!function_exists('isAdminActiveMenu')) {
    /**
     * Check is admin menu active
     *
     * @param string $route_name
     * @param array $param
     * @return boolean
     */
    function isAdminActiveMenu($route_name, $param = [])
    {
        $current_route = Route::currentRouteName();
        if (!empty($current_route)) {
            if (in_array($current_route, array('comment.type.filter', 'comment.index', 'comment.edit')) && $route_name == 'blog.index') {
                return true;
            } else {
                return request()->is(trim(route($route_name, $param, false), '/')) || request()->is(trim(route($route_name, $param, false), '/') . '/*');
            }
        }
    }
}

// if (!function_exists('getImageRecommandedDataByModuleName')) {
//     /**
//      * Get image recommended information
//      *
//      * @param string $module
//      * @return string
//      */
//     function getImageRecommandedDataByModuleName($module)
//     {
//         $recommended_size = [];
//         foreach (config(IMAGE_SIZES . $module . SIZES, []) as $v) {
//             if (!empty($v['is_recommended'])) {
//                 return $v;
//             }
//         }
//         return $recommended_size;
//     }
// }

if (!function_exists('getImageRecommendedSize')) {
    /**
     * Get image recommended size
     *
     * @param string $folder
     * @return string
     */
    function getImageRecommendedSize($folder)
    {
        $recommended_size = '';
        foreach (config(IMAGE_SIZES . $folder . SIZES, []) as $v) {
            if (!empty($v['size']) && !empty($v['is_recommended'])) {
                $recommended_size .= "Max size " . $v['size'] . "(MB)  ";
            }
            if (!empty($v['is_recommended']) && !empty($v['width']) && !empty($v['height'])) {
                $recommended_size .= 'and Recommended Size: ' . (isset($v['recommended_custom']) ? $v['recommended_custom'] : $v['width'] . 'PX x ' . $v['height'] . 'PX') . ' (Allowed only jpg, jpeg, png and gif images)';
            }
            if (!empty($v['is_document'])) {
                $recommended_size .= " (Allowed only pdf,doc and docx)";
            }
            if (!empty($v['is_audio'])) {
                $recommended_size .= " (Allowed only mp3,oga,ogg and wav)";
            }
            if (!empty($v['is_video'])) {
                $recommended_size .= " (Allowed only mov,mp4,webm and wmv)";
            }
        }
        return $recommended_size;
    }
}

if (!function_exists('getImageUploadSizeInMB')) {
    /**
     * Get image upload size in MB
     *
     * @param string $module
     * @return int
     */
    function getImageUploadSizeInMB($module)
    {
        $recommended_size = '';
        foreach (config(IMAGE_SIZES . $module . SIZES, []) as $v) {
            if (!empty($v['size']) && !empty($v['is_recommended'])) {
                $recommended_size = $v['size'];
            }
        }

        return $recommended_size;
    }
}

if (!function_exists('bytesToMB')) {
    function bytesToMB($bytes, $decimals = 2)
    {
        return number_format($bytes / 1048576, $decimals);
    }
}

if (!function_exists('getSlugText')) {
    /**
     * Get Slug
     *
     * @param string $title
     * @param $model
     * @return string
     */
    function getSlugText($title, $model)
    {
        $slug = Str::slug($title);
        if ($slug == '') {
            $slug = 1;
        }
        $slugCount = count($model->whereRaw("slug REGEXP '^{$slug}(-[0-9]*)?$'")->get());
        $slug =  ($slugCount > 0) ? "{$slug}-{$slugCount}" : $slug;
        return $slug;
    }
}

if (!function_exists('getPasswordPolicy')) {
    /**
     * Get password minimum length and password regexp on basis of password strength
     *
     * @param array $passwordValidationRule
     * @return array
     */
    function getPasswordPolicy($passwordValidationRule)
    {
        if (empty($passwordValidationRule)) {
            $passwordValidationRule = [];
        }
        $min = !empty(siteconfig('minimum_password_length')) ? siteconfig('minimum_password_length') : 6;
        $passwordValidationRule[] = 'min:' . $min;
        $ValidationRuleRegx = 'regex:/^[A-Za-z0-9!"#.@_~$%^*:|\-\(\)]*$/';
        if (siteconfig('password_strength') == 'Easy') {
            $policy_Strength = 'easy';
            $passwordValidationRule[] = $ValidationRuleRegx;
        } elseif (siteconfig('password_strength') == 'Medium') {
            $policy_Strength = 'medium';
            $passwordValidationRule[] = $ValidationRuleRegx;
            $passwordValidationRule[] = 'regex:/[a-z]/';
            $passwordValidationRule[] = 'regex:/[A-Z]/';
            $passwordValidationRule[] = 'regex:/[0-9]/';
        } elseif (siteconfig('password_strength') == 'Strong') {
            $policy_Strength = 'strong';
            $passwordValidationRule[] = 'regex:/[!"#.@_~$%^*:|\-\(\)]/';
            $passwordValidationRule[] = 'regex:/[a-z]/';
            $passwordValidationRule[] = 'regex:/[A-Z]/';
            $passwordValidationRule[] = 'regex:/[0-9]/';
            $passwordValidationRule[] = $ValidationRuleRegx;
        }

        return array('passwordValidationRule' => $passwordValidationRule, 'passwordMinLength' => $min, 'passwordStrength' => $policy_Strength);
    }
}

// if (!function_exists('convertToBytes')) {
//     /**
//      * Convert to Byte size
//      *
//      * @return array
//      */
//     function convertToBytes($input, $convertFrom = "mb")
//     {
//         switch ($convertFrom) {
//             case "kb":
//                 $output = $input * 1024;
//                 break;

//             case "gb":
//                 $output = $input * 1024 * 1024 * 1024;
//                 break;
//             case "mb":
//             default:
//                 $output = $input * 1024 * 1024;
//                 break;
//         }

//         return $output;
//     }
// }


// if (!function_exists('removeSpecialCharacter')) {
//     /**
//      * remove special characters
//      * @param string $content
//      *
//      * @return string
//      */
//     function removeSpecialCharacter($content)
//     {
//         $content = str_replace(' ', '-', $content);
//         return preg_replace('/[^A-Za-z0-9\-]/', '', $content);
//     }
// }

// if (!function_exists('filterBlockContent')) {
//     /**
//      * remove special characters
//      * @param string $content
//      *
//      * @return string
//      */
//     function filterBlockContent($content)
//     {
//         $allowed_tags = '<b><br><em><hr><i><li><ol><p><s><span><u><ul><strong><div><ul><li><svg><a><path><button><input><form><h2><h1><audio><video><source><table><figure><figcaption><img><tr><td><thead><tbody><th><label><sup><sub>';
//         return strip_tags($content, $allowed_tags);
//     }
// }


if (!function_exists('displayMessages')) {
    function displayMessages($module, $status)
    {
        $message = '';
        if ($status == '1') {
            $message = __($module . '.record_active_success');
        } elseif ($status == '0') {
            $message = __($module . '.record_inactive_success');
        }
        return $message;
    }
}

if (!function_exists('displayDate')) {
    function displayDate($value)
    {
        if (isset($value)) {
            $timestamp = $value;
            return \Carbon\Carbon::parse($timestamp)->format(config('app.date_format'));
        }
        return false;
    }
}

// if (!function_exists('displayTime')) {
//     function displayTime($value)
//     {
//         if (isset($value)) {
//             $timestamp = $value;
//             return  \Carbon\Carbon::parse($timestamp)->format(config('app.time_format'));
//         }
//         return false;
//     }
// }

// if (!function_exists('truncateStringWithWholeWord')) {
//     function truncateStringWithWholeWord($string, $limit_number)
//     {
//         $parts = preg_split('/([\s\n\r]+)/', $string, null, PREG_SPLIT_DELIM_CAPTURE);
//         $parts_count = count($parts);

//         $length = 0;
//         $last_part = 0;
//         for (; $last_part < $parts_count; ++$last_part) {
//             $length += strlen($parts[$last_part]);
//             if ($length > $limit_number) {
//                 break;
//             }
//         }

//         return implode(array_slice($parts, 0, $last_part));
//     }
// }

if (!function_exists('footerCopyRightText')) {
    function footerCopyRightText()
    {
        $projectStYear = env("START_YEAR", 0);
        if ($projectStYear != date('Y') && $projectStYear != 0) {
            $copyRightYear = $projectStYear . ' - ' . date('Y');
        } else {
            $copyRightYear = date('Y');
        }
        return  $copyRightYear;
    }
}

if (!function_exists('getBaseUrl')) {
    function getBaseUrl($slug)
    {
        return url($slug);
    }
}


if (!function_exists('canUserAccess')) {
    /**
     * canAccess
     *
     * @param string $module
     * @param array $param
     * @param string $type key|route
     * @return boolean
     */
    function canUserAccess($module, $param = [], $type = 'key', $user_type = '')
    {
        $user_type = !empty($user_type) ? $user_type : Auth::user()->user_type_id;
        return \App\UserType::checkHasPermission($module, $param, $type, $user_type);
    }
}

// if (!function_exists('isValidUserLink')) {
//     function isValidUserLink($request, $token = null)
//     {
//         $user = \App\User::where('email', $request->email)->where('user_type_id', 3)->first();
//         if ($user == null) {
//             return true;
//         }
//         return app(\Illuminate\Auth\Passwords\PasswordBroker::class)->tokenExists($user, $token);
//     }
// }

if (!function_exists('priceFormat')) {
    function priceFormat($value)
    {
        return number_format($value, 2);
    }
}

// if (!function_exists('minstohoursminconversion')) {
//     function minstohoursminconversion($value)
//     {
//         $hours = (int) floor($value / 60);
//         $minutes = (int) $value % 60;

//         return $hours . 'hrs, ' . $minutes . 'mins';
//     }
// }

if (!function_exists('getSecret')) {
    function getSecret($secretId, $versionId = '1')
    {
        if (env('APP_ENV') == 'local' || env('APP_ENV') == 'staging' || env('APP_ENV') == 'development') {
            return env($secretId);
        } elseif (env('APP_ENV') == 'production') {
            $versionId = '2';
        }

        $client = new SecretManagerServiceClient([
            'credentials' => [
                'type' => env('GOOGLE_CLOUD_ACCOUNT_TYPE'),
                'private_key_id' => env('GOOGLE_CLOUD_PRIVATE_KEY_ID'),
                'private_key' => env('GOOGLE_CLOUD_PRIVATE_KEY'),
                'client_email' => env('GOOGLE_CLOUD_CLIENT_EMAIL'),
                'client_id' => env('GOOGLE_CLOUD_CLIENT_ID'),
                'auth_uri' => env('GOOGLE_CLOUD_AUTH_URI'),
                'token_uri' => env('GOOGLE_CLOUD_TOKEN_URI'),
                'auth_provider_x509_cert_url' => env('GOOGLE_CLOUD_AUTH_PROVIDER_CERT_URL'),
                'client_x509_cert_url' => env('GOOGLE_CLOUD_CLIENT_CERT_URL'),
            ]
        ]);

        // Build the resource name of the secret version.
        $name = $client->secretVersionName(env('GOOGLE_CLOUD_PROJECT_ID'), $secretId, $versionId);

        // Access the secret version.
        $response = $client->accessSecretVersion($name);

        return $response->getPayload()->getData();
    }
}

if (!function_exists('trueFalseWord')) {
    function trueFalseWord($value)
    {
        return $value == 1 ? 'True' : 'False';
    }
}
//Generate refer code
// if (!function_exists('generateReferCode')) {
//     function generateReferCode()
//     {
//         $latestId = User::latest('id')->value('id');
//         $newId = $latestId + 1;
//         $newIdFormatted = str_pad($newId, 4, '0', STR_PAD_LEFT);
//         $newReferCode = 'CL-' . $newIdFormatted;

//         return $newReferCode;
//     }
// }

// //Get all stripe customer
// if (!function_exists('getAllStripeCustomer')) {
//     function getAllStripeCustomer()
//     {
//         $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
//         $customers = $stripe->customers->all(['limit' => 3]);
//         return $customers;
//     }
// }



// //Retrieve stripe customer
// if (!function_exists('retrieveStripeCustomer')) {
//     function retrieveStripeCustomer($customer_id)
//     {
//         $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
//         $customer = $stripe->customers->retrieve($customer_id, []);
//         return $customer;
//     }
// }

// //Get all stripe products
// if (!function_exists('getAllStripeProduct')) {
//     function getAllStripeProduct()
//     {
//         $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
//         $products = $stripe->products->all(['limit' => 3]);
//         return $products;
//     }
// }





// //Retrieve stripe product total amount
// if (!function_exists('retrieveStripeProductAmount')) {
//     function retrieveStripeProductAmount($product_id)
//     {
//         Log::info('In function oauth2',[env('STRIPE_SECRET_KEY')]);
//         $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
//         $product = $stripe->products->retrieve($product_id, []);
//         $total = 0;
//         Log::info('In function oauth1',[$product]);
//         Log::info('In function oauth3',[$product->metadata->toArray()]);
//         foreach ($product->metadata->toArray() as $key => $value) {
//             if($key == "Annual Fees" || $key == "Submission Fees" || $key == "Surcharge Fees"){
//                 $total += $value;
//             }
//         }
//         return $total;
//     }
// }


//Retrieve stripe product total amount by user id
if (!function_exists('retrievePriceListOfUser')) {
    function retrievePriceListOfUser($user_id,$bar_user_references_id = 0,$isForRenew = 0)
    {
        $user = User::find($user_id);
        $bar_ids = $user->getUserBarIdsNeedToPay($bar_user_references_id,$isForRenew);
        $statebars = Bar::whereIn('id', $bar_ids)->get();
        $product_data = [];
        foreach ($statebars as $bar) {
            $product_data[] = ['id'=>$bar->annual_price_stripe_price_id,'qty'=>1,'bar_id'=>$bar->id,'bar_name'=>$bar->state_name];

            $product_data[] =  ['id'=>$bar->surcharge_fees_stripe_price_id,'qty'=>1,'bar_id'=>$bar->id,'bar_name'=>$bar->state_name];

            $product_data[] =  ['id'=>$bar->submission_fees_stripe_price_id,'qty'=>$bar->hours_needed_per_cycle,'bar_id'=>$bar->id,'bar_name'=>$bar->state_name];
        }
        $priceList = retrieveStripePriceList($product_data);
        return $priceList;
    }
}



//Retrieve stripe product total amount by user id
if (!function_exists('retrieveTotalProductAmountByUser')) {
    function retrieveTotalProductAmountByUser($user_id)
    {
        $priceList = retrievePriceListOfUser($user_id);
        $total_product_price = collect($priceList)->sum('amount');
        return isset($total_product_price) ? $total_product_price : 0;
    }
}


// //Create stripe plan
// if (!function_exists('createStripePlan')) {
//     function createStripePlan()
//     {
//         $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
//         $plan = $stripe->plans->create([
//             'amount' => 215,
//             'currency' => 'usd',
//             'interval' => 'yearly',
//             'product' => 'prod_P8CJ52JoQIkmXI',
//         ]);
//         return $plan;
//     }
// }

//Retrieve stripe plan
// if (!function_exists('retrieveStripePlan')) {
//     function retrieveStripePlan($plan_id)
//     {
//         $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
//         $plan = $stripe->plans->retrieve($plan_id, []);
//         return $plan;
//     }
// }

// //Get all stripe plans
// if (!function_exists('getAllStripePlans')) {
//     function getAllStripePlans()
//     {
//         $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
//         $plans = $stripe->plans->all(['limit' => 3]);
//         return $plans;
//     }
// }

//Create stripe subscription
if (!function_exists('createStripeSubscription')) {
    function createStripeSubscription($customer_id, $priceList,$payment_method_id){
        try {
            $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));

            $priceItems = [];
            foreach ($priceList as $price) {
                $priceItems[] = [
                    'price' => $price['id'],
                    'quantity' => $price['qty'],
                ];
            }

            $subscription = $stripe->subscriptions->create([
                'customer' => $customer_id,
                'items' => $priceItems,
                'default_payment_method' => $payment_method_id,
            ]);

            return $subscription;
        } catch (Exception $e) {
            throw new Exception('Unexpected error: ' . $e->getMessage());
        }
    }

}



//Get all stripe plans
// if (!function_exists('getAllStripeSubscriptions')) {
//     function getAllStripeSubscriptions()
//     {
//         $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
//         $subscriptions = $stripe->subscriptions->all(['limit' => 3]);
//         return $subscriptions;
//     }
// }

//Get all stripe prices
// if (!function_exists('getAllStripePrices')) {
//     function getAllStripePrices()
//     {
//         $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
//         $prices = $stripe->prices->all(['limit' => 3]);
//         return $prices;
//     }
// }

// //Retrieve stripe prices
// if (!function_exists('searchStripePrice')) {
//     function searchStripePrice($product_id)
//     {
//         $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
//         $prices = $stripe->prices->search([
//             'query' => 'active:\'true\' AND product:\'' . $product_id . '\' ',
//         ]);
//         return $prices;
//     }
// }

//Create stripe payment method
// if (!function_exists('createStripePaymentMethod')) {
//     function createStripePaymentMethod()
//     {
//         $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
//         $method = $stripe->paymentMethods->create([
//             'type' => 'card',
//             'card' => [
//                 'number' => '4242424242424242',
//                 'exp_month' => 8,
//                 'exp_year' => 2026,
//                 'cvc' => '314',
//             ],
//         ]);
//         return $method;
//     }
// }

//Create payment intent
// if (!function_exists('createPaymentIntent')) {
//     function createPaymentIntent($request)
//     {
//         $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
//         $payment =  $stripe->paymentIntents->create([
//             'amount' => 2000,
//             'currency' => 'usd',
//             'automatic_payment_methods' => ['enabled' => true],
//         ]);
//         return $payment;
//     }
// }


//Get active user subscriptions
if (!function_exists('getUserSubscription')) {
    function getUserSubscription($user_id)
    {
        $user = User::find($user_id);
        $data = DB::table('users')
            ->join('subscriptions', 'subscriptions.user_id', 'users.id')
            ->where('subscriptions.end_date', '>', Carbon::now()->format('Y-m-d'))
            ->where('users.id', $user->id)
            ->get();
        return $data;
    }
}

//Check active user subscriptions
if (!function_exists('checkActiveUserSubscription')) {
    function checkActiveUserSubscription($user_id)
    {
        $user = User::find($user_id);
        $status = false;
        if ($user) {
            $data = DB::table('users')
                ->join('subscriptions', 'subscriptions.user_id', 'users.id')
                ->where('subscriptions.end_date', '>', Carbon::now()->format('Y-m-d'))
                ->where('subscriptions.stripe_subscription_status', 'active')
                ->where('subscriptions.status', 1)
                ->where('users.id', $user->id)
                ->get();
            $status = $data->isNotEmpty();
        }
        return $status;
    }
}

//Sent subscription email invoice
if (!function_exists('sendSubscriptionInvoice')) {
    function sendSubscriptionInvoice($user_id, $stripe_invoice_id)
    {
        $user = User::find($user_id);
        $invoiceData = [
            'invoice_pdf_url' => getSubscriptionInvoicePdf($stripe_invoice_id)
        ];
        $user->notify(new SentInvoice($user, $invoiceData));
    }
}

//Cancel user subscription
if (!function_exists('cancelUserSubscription')) {
    function cancelUserSubscription($stripe_subscription_id, $cancelOption = 0, $cancelFor = '')
    {
        try {
            $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));

            if ($cancelOption == 0) {
                // terminate now
                $stripe->subscriptions->cancel($stripe_subscription_id, [
                    'cancellation_details' => ['comment' => $cancelFor],
                ]);
            } else if ($cancelOption == 1) {
                // terminate on plan completion
                $stripe->subscriptions->update($stripe_subscription_id, [
                    'cancel_at_period_end' => true,
                ]);
            }
            return 1;
        } catch (Exception $e) {
            throw new Exception('Unexpected error: ' . $e->getMessage());
        }
    }
}


// //Resume user subscription
// if (!function_exists('resumeUserSubscription')) {
//     function resumeUserSubscription($stripe_subscription_id)
//     {
//         $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
//         $status = $stripe->subscriptions->resume($stripe_subscription_id, ['billing_cycle_anchor' => 'now']);
//         return $status;
//     }
// }

//userFirmAdmin
if (!function_exists('userFirmAdmin')) {
    function userFirmAdmin($user_id)
    {
        $user = User::find($user_id);
        if (isset($user) && isset($user->firmcode)) {
            $firm = Firm::where('code', $user->firmcode)->first();
            if (isset($firm)) {
                return $firm;
            } else {
                return null;
            }
        } else {
            return null;
        }
    }
}

//userFirmAdmin
if (!function_exists('userFirm')) {
    function userFirm($user_id)
    {
        $user = User::find($user_id);
        if (isset($user) && isset($user->firmcode)) {
            $firm = Firm::where('code', $user->firmcode)->first();
            if (isset($firm) && isset($firm->name) && isset($firm->code)) {
                return $firm->name . '<br/><span class="badge bg-primary text-light">' . $firm->code . '</span>';
            } else {
                return null;
            }
        } else {
            return null;
        }
    }
}

//checkUserBarsNeedTopay
if (!function_exists('checkUserBarsNeedTopay')) {
    function checkUserBarsNeedTopay($user_id)
    {
        $user = User::find($user_id);
        $bar_ids = $user->getUserBarIdsNeedToPay();

        if (count($bar_ids) > 0) {
            return true;
        } else {
            return false;
        }
    }
}

//getUserBarsNeedTopay
if (!function_exists('getUserBarsNeedTopay')) {
    function getUserBarsNeedTopay($user_id)
    {
        $user = User::find($user_id);
        $bar_ids = $user->getUserBarIdsNeedToPay();
        if (isset($bar_ids)) {
            $bar = Bar::whereIn('id', $bar_ids)->get();
            return isset($bar) ? $bar : null;
        } else {
            return null;
        }
    }
}


//getUserBars as Barname +1 more
if (!function_exists('getUserBarsCustom')) {
    function getUserBarsCustom($user_id)
    {
        $isBarExist = BarUserReference::where('user_id', $user_id)->pluck('bar_id');
        $total_count =  count($isBarExist);
        if (isset($isBarExist) && $total_count == 1) {
            $bar = Bar::whereIn('id', $isBarExist)->first();
            return isset($bar) ? $bar->state_name : null;
        } else if (isset($isBarExist) && $total_count > 1) {
            $bar = Bar::whereIn('id', $isBarExist)->first();
            return isset($bar) ? $bar->state_name . ' +' . $total_count - 1 . ' more' : null;
        } else {
            return 'N/A';
        }
    }
}


if (!function_exists('secondsToMinuteSecond')) {
    function secondsToMinuteSecond($seconds)
    {
        $minutes = floor($seconds / 60);
        $remainingSeconds = $seconds % 60;
        return sprintf('%02d:%02d', $minutes, $remainingSeconds);
    }
}

if (!function_exists('secondsToMinute')) {
    function secondsToMinute($seconds)
    {
        $minutes = floor($seconds / 60);
        return sprintf('%02d', $minutes);
    }
}

if (!function_exists('minuteSecondToSeconds')) {
    function minuteSecondToSeconds($time)
    {
        // Split the time into minutes and seconds
        $parts = explode(':', $time);

        // If the time format is not correct, return false or throw an exception
        if (count($parts) != 2 || !is_numeric($parts[0]) || !is_numeric($parts[1])) {
            return false; // or throw new Exception('Invalid time format');
        }

        // Calculate total seconds
        $seconds = ($parts[0] * 60) + $parts[1];

        return $seconds;
    }
}

if (!function_exists('minutesToSeconds')) {
function minutesToSeconds($minutes) {
    return $minutes * 60;
}
}

// if (!function_exists('hourMinuteSecondToSeconds')) {
//     function hourMinuteSecondToSeconds($time)
//     {
//         // Split the time into hours, minutes, and seconds
//         $parts = explode(':', $time);

//         // If the time format is not correct, return false or throw an exception
//         if (count($parts) != 3 || !is_numeric($parts[0]) || !is_numeric($parts[1]) || !is_numeric($parts[2])) {
//             return false; // or throw new Exception('Invalid time format');
//         }

//         // Calculate total seconds
//         $seconds = ($parts[0] * 3600) + ($parts[1] * 60) + $parts[2];

//         return $seconds;
//     }
// }


if (!function_exists('checkNeedToAddCredit')) {
    function checkNeedToAddCredit($lastCreditFor, $nextCreditAt, $listen_time, $creditInSeconds, $creditFor = [])
    {
        if ($nextCreditAt <= $listen_time) {
            $creditFor[] = "$lastCreditFor-$nextCreditAt";
            return checkNeedToAddCredit($nextCreditAt, $nextCreditAt + $creditInSeconds, $listen_time, $creditInSeconds, $creditFor);
        } else {
            return $creditFor;
        }
    }
}

if (!function_exists('getSupportEmail')) {
    function getSupportEmail()
    {
        return "support@clearly.legal";
    }
}

//Create stripe customer
if (!function_exists('createStripeCustomer')) {
    function createStripeCustomer($data)
    {
        try {
            $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
            $customer = $stripe->customers->create($data);
            return $customer;
        } catch (Exception $e) {
            throw new Exception('Unexpected error: ' . $e->getMessage());
        }

    }
}

//Create stripe product
if (!function_exists('createStripeProduct')) {
    function createStripeProduct($request)
    {
        try {
            $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
            $product = $stripe->products->create($request);
            return $product;
        } catch (Exception $e) {
            throw new Exception('Unexpected error: ' . $e->getMessage());
        }
    }
}


//create Stripe Price:
if (!function_exists('createStripePrice')) {
    function createStripePrice($data)
    {
        try {
            $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
            $price = $stripe->prices->create($data);
            return $price;
        } catch (Exception $e) {
            throw new Exception('Unexpected error: ' . $e->getMessage());
        }

    }
}

//Retrieve stripe product
// if (!function_exists('retrieveStripeProduct')) {
//     function retrieveStripeProduct($product_id)
//     {
//         $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
//         $product = $stripe->products->retrieve($product_id, []);
//         return $product;
//     }
// }

//Retrieve stripe prices list
if (!function_exists('retrieveStripePriceList')) {
    function retrieveStripePriceList($product_data)
    {
        try {
            $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
            $priceList = [];
            foreach ($product_data as $product) {
                $productData = $stripe->products->retrieve($product['id']);
                $defaultPriceId = $productData->default_price;

                if($defaultPriceId && $defaultPriceId != null && $defaultPriceId != 'null'){
                    $price = $stripe->prices->retrieve($defaultPriceId);


                    $priceList[] = [
                        'id' => $price->id,
                        'bar_id' => $product['bar_id'],
                        'bar_name' => $product['bar_name'],
                        'name' => $price->metadata->productName,
                        'unit_amount' => ($price->unit_amount_decimal/100),
                        'unit_amount_display' => getPricePrefix(priceFormat(($price->unit_amount_decimal/100))),
                        'qty' => $product['qty'],
                        'amount' => ($price->unit_amount_decimal/100)*$product['qty'],
                        'amount_display' => getPricePrefix(priceFormat(($price->unit_amount_decimal/100)*$product['qty'])),
                    ];

                }else{

                    $allPrices = $stripe->prices->all(['product'=>$product['id']]);
                    foreach ($allPrices->data as $price) {
                        $priceList[] = [
                            'id' => $price->id,
                            'bar_id' => $product['bar_id'],
                            'bar_name' => $product['bar_name'],
                            'name' => $price->metadata->productName,
                            'unit_amount' => ($price->unit_amount_decimal/100),
                            'unit_amount_display' => getPricePrefix(priceFormat(($price->unit_amount_decimal/100))),
                            'qty' => $product['qty'],
                            'amount' => ($price->unit_amount_decimal/100)*$product['qty'],
                            'amount_display' => getPricePrefix(priceFormat(($price->unit_amount_decimal/100)*$product['qty'])),
                        ];
                    }
                }
            }
            return $priceList;
        } catch (Exception $e) {
            throw new Exception('Unexpected error: ' . $e->getMessage());
        }

    }
}

//Retrieve stripe by metaData
if (!function_exists('retrieveStripePriceListByPriceForMetaData')) {
    function retrieveStripePriceListByPriceForMetaData($priceFor)
    {
        try {
            $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));

            // Step 1: Fetch prices with matching metadata
            $prices = $stripe->prices->search([
                'query' => "active:'true' AND metadata['pricefor']:'{$priceFor}'",
            ]);

            Log::info('Retrieved prices:', [$prices->data]);

            $matchedPrices = [];

            foreach ($prices->data as $price) {
                // Step 2: Fetch the related product
                $product = $stripe->products->retrieve($price->product);

                // Step 3: Include price if it's the default or if no default is set
                $isDefault = isset($product->default_price) ? $product->default_price === $price->id : true;

                if ($isDefault) {
                    $matchedPrices[] = $price;

                    Log::info('Using price (default or no default set):', [
                        'product_id' => $product->id,
                        'product_name' => $product->name,
                        'price_id' => $price->id
                    ]);
                } else {
                    Log::info('Skipping price (not default):', [
                        'product_id' => $product->id,
                        'price_id' => $price->id,
                        'expected_default' => $product->default_price
                    ]);
                }
            }

            Log::info('Final matched prices:', [$matchedPrices]);

            return $matchedPrices;

        } catch (Exception $e) {
            Log::error('Stripe price fetch error: ' . $e->getMessage());
            return [];
        }
    }
}


//Create Payment Link
if (!function_exists('createPaymentLink')) {
    function createPaymentLink($prices,$redirectUrl,$customer_id='',$promocodeId = null)
    {
        try {
            $line_items = [];
            if(count($prices) > 0){
                foreach ($prices as $price) {
                    $line_items[] = [
                        'price' => $price['id'],
                        'quantity' => $price['qty']
                    ];
                }
            }
            $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
            $checkoutSessionData = [
                'customer'=>$customer_id,
                'success_url' => urldecode($redirectUrl),
                'line_items' => $line_items,
                'mode' => 'subscription',
                // 'allow_promotion_codes' => true
            ];
            if ($promocodeId) {
                $checkoutSessionData['discounts'] = [['promotion_code' => $promocodeId]];
            } else {
                $checkoutSessionData['allow_promotion_codes'] = true;
            }

            try {
                return $stripe->checkout->sessions->create($checkoutSessionData);

            } catch (\Stripe\Exception\InvalidRequestException $e) {
                $stripeError = $e->getError();

                // If it's a promo code-related issue, retry without it
                if ($stripeError->type === 'invalid_request_error' && (str_contains($stripeError->message, 'coupon') || str_contains($stripeError->message, 'Coupon') || str_contains($stripeError->message, 'promotion') || str_contains($stripeError->message, 'Promotion'))) {
                    Log::warning('Promo Code Issue: ' . $promocodeId . ' - Retrying without it.');

                    // Retry without promo code
                    unset($checkoutSessionData['discounts']);
                    $checkoutSessionData['allow_promotion_codes'] = true;

                    return $stripe->checkout->sessions->create($checkoutSessionData);
                }

                throw $e; // If it's a different error, rethrow it
            }




        } catch (Exception $e) {
            throw new Exception('Unexpected error: ' . $e->getMessage());
        }

    }
}

//Retrieve stripe subscription
if (!function_exists('retrieveStripeSubscription')) {
    function retrieveStripeSubscription($subscription_id)
    {
        try {
            $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
            $subscription = $stripe->subscriptions->retrieve($subscription_id, []);
            return $subscription;
        } catch (Exception $e) {
            throw new Exception('Unexpected error: ' . $e->getMessage());
        }

    }
}

//Retrieve stripe promocode
if (!function_exists('retrieveStripePromocode')) {
    function retrieveStripePromocode($promotion_code)
    {
        try {
            $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
            $promocode = $stripe->promotionCodes->retrieve($promotion_code, []);

            return $promocode;
        } catch (Exception $e) {
            throw new Exception('Unexpected error: ' . $e->getMessage());
        }

    }
}

//Get ENV prefix
if (!function_exists('getEnvPrefix')) {
    function getEnvPrefix()
    {
        $prefix = '';
        if (env('APP_ENV_CODE') == 'local') {
            $prefix = 'LOCAL-';
        }else if (env('APP_ENV_CODE') == 'staging') {
            $prefix = 'STAG-';
        }else if (env('APP_ENV_CODE') == 'development') {
            $prefix = 'DEV-';
        }else if (env('APP_ENV_CODE') == 'production') {
            $prefix = '';
        }
        return $prefix;
    }
}

//Get ENV prefix
if (!function_exists('getPricePrefix')) {
    function getPricePrefix($amount)
    {
        return '$'.$amount;
    }
}

if (!function_exists('getCreditUsingCreditFor')) {
    function getCreditUsingCreditFor($start,$end){
        $seconds = $end - $start;
        //logic based on 1 hours = 1 credit;
        $secondsInOneHour = 3600;
        $creditPerHour = 1;
        return $creditPerHour * $seconds / $secondsInOneHour;
    }
}

//function to create stripe product with pricing
if (!function_exists('createStripePriceId')) {
    function createStripePriceId($name,$price,$priceFor){
        $product_annual_price = createStripeProduct(['name'=>$name]);
        createStripePrice([
            'currency' => 'usd',
            'unit_amount_decimal' => $price * 100,
            'recurring' => ['interval' => 'year'],
            'product'=>$product_annual_price->id,
            'metadata'=>['pricefor'=>$priceFor,'productName'=>$name]
        ]);
        return $product_annual_price->id;
    }
}


//function to create stripe product with pricing
if (!function_exists('getBarsOfUser')) {
    function getBarsOfUser($user_id){
        return DB::table('bar_user_references')
        ->select('bar_user_references.id','bars.state_name', 'bars.hours_needed_per_cycle as hours', 'bars.shortest_length_accepted as shortest_length_required', 'bar_user_references.bar_id', 'bar_user_references.bar_number','bars.submission_fees_stripe_price_id','bars.surcharge_fees_stripe_price_id','bars.annual_price_stripe_price_id','bar_user_references.is_paid','bar_user_references.paid_by')
        ->join('bars', 'bars.id', 'bar_user_references.bar_id')
        ->where('bar_user_references.user_id', $user_id)
        ->get();
    }
}


//function to fet Bar name from barid
if (!function_exists('getBarName')) {
    function getBarName($bar_id){
        $bar=Bar::where('id',$bar_id)->first();
        return $bar->state_name;
    }
}

// if (!function_exists('getCreditofBars')) {
//     function getCreditofBars($bar_id){
//         $barCreditsSum = DB::table('contents_states')
//         ->where('bar_id', $bar_id)
//         ->sum('credit_provided_by_the_course');

//         return $barCreditsSum > 0 ? $barCreditsSum : 0;
//     }
// }

// not in use, using User->getCreditsSubmittedForBar instead
// if (!function_exists('getSubmittedCreditofBars')) {
//     function getSubmittedCreditofBars($bar_id){
//         $user_id = Auth::user()->id;
//         $barCreditsSubmittedSum = DB::table('submissions')
//         ->where('bar_id', $bar_id)
//         ->where('user_id',$user_id)
//         ->sum('credit_submitted');
//         return $barCreditsSubmittedSum > 0 ? $barCreditsSubmittedSum : 0;
//     }
// }


//Get Stripe Invoice Pdf
if (!function_exists('getSubscriptionInvoicePdf')) {
    function getSubscriptionInvoicePdf($stripe_invoice_id)
    {
        try {
            $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
            $invoice = $stripe->invoices->retrieve($stripe_invoice_id, []);
            return $invoice->invoice_pdf;
        } catch (Exception $e) {
            throw new Exception('Unexpected error: ' . $e->getMessage());
        }

    }
}

//get Needed stripe subscription data
if (!function_exists('getNeededSubscriptionDataFromSubscription')) {
    function getNeededSubscriptionDataFromSubscription($subscription)
    {
        $sub_total_amount = 0;
        $discount = $subscription->discount ?: 0;
        $amount_off = !empty($discount) ? ($discount->coupon->amount_off ?: 0) : 0;
        $percent_off = !empty($discount) ? ($discount->coupon->percent_off ?: 0) : 0;
        $is_percentage = !empty($discount) ? ($discount->coupon->percent_off == null ? 0 : 1) : 0;

        foreach ($subscription->items->data as $key => $data) {
            $sub_total_amount += ($data->plan->amount_decimal/100)*$data->quantity;
            $pricing[] = [
                'name' => $data->plan->metadata->productName,
                'unit_amount' => ($data->plan->amount_decimal/100),
                'unit_amount_display' => getPricePrefix(priceFormat(($data->plan->amount_decimal/100))),
                'qty' => $data->quantity,
                'amount' => ($data->plan->amount_decimal/100)*$data->quantity,
                'amount_display' => getPricePrefix(priceFormat(($data->plan->amount_decimal/100)*$data->quantity))
            ];
        }

        $discount_amount = 0; 
        if($percent_off != 0){
            $discount_amount = $sub_total_amount * $discount->coupon->percent_off / 100; 
        }else{
            $discount_amount = $amount_off/100;
        }
        $total_amount = $sub_total_amount - $discount_amount; 

        $total_discount_display = getPricePrefix(priceFormat(($discount_amount)));
        return [
            'startDate' => displayDate($subscription->current_period_start),
            'endDate' => displayDate($subscription->current_period_end),
            'status' =>  $subscription->status,
            'sub_total_amount' => $sub_total_amount,
            'sub_total_amount_display' => getPricePrefix(priceFormat($sub_total_amount)),
            'total_amount' => $total_amount,
            'total_amount_display' => getPricePrefix(priceFormat($total_amount)),
            'amount_off' => $amount_off,
            'percent_off' => $percent_off,
            'discount_amount'=>$discount_amount,
            'is_percentage' => $is_percentage,
            'total_discount_display' => $total_discount_display,
            'pricing' => $pricing,
            'invoice' => getSubscriptionInvoicePdf($subscription->latest_invoice),
        ];
    }
}

//Get Stripe User payment Methods
if (!function_exists('getAllPaymentMethodOfUser')) {
    function getAllPaymentMethodOfUser($stripe_customer_id)
    {
        try {
            $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
            $paymentMethods = $stripe->customers->allPaymentMethods($stripe_customer_id,[]);
            return $paymentMethods->data;
        } catch (\Stripe\Exception\ApiErrorException $e) {
            throw new Exception('Unexpected error: ' . $e->getMessage());
        }
    }
}
//Get Stripe User payment Methods
if (!function_exists('addNewCardToUser')) {
    function addNewCardToUser($stripe_customer_id,$stripe_card_token)
    {
        try {
            $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET_KEY'));
            $card = $stripe->customers->createSource($stripe_customer_id, ['source' => $stripe_card_token]);
            return $card;
        } catch (\Stripe\Exception\ApiErrorException $e) {
            throw new Exception('Unexpected error: ' . $e->getMessage());
        }
    }
}

//Get Name of approval status using ID
if (!function_exists('getFirmApprovalStatusName')) {
    function getFirmApprovalStatusName($id)
    {
        $status = config('firmapprovalstatus');
        $name = false;

        foreach ($status as $item) {
            if ($item->id == $id) {
                $name = $item->name;
                break;
            }
        }
        return $name;
    }
}
//Get Name of approval status using ID
if (!function_exists('checkFirmUserSubscriptionOptions')) {
    function checkFirmUserSubscriptionOptions($firm_user_subscription,$firm_status_id)
    {
        //if Firm is set for ALL the they have two options 1) pay & accept  2)reject
        $result = true;
        if($firm_user_subscription == "all"){
            if($firm_status_id == 2){
                $result = false;
            }
        }

        //if Firm is set for some the they have three options 1) pay & accept 2) accept but pay by user  3)reject


        //if Firm is set for no the they have two options 1) accept but pay by user  2)reject
        if($firm_user_subscription == "no"){
            if($firm_status_id == 1){
                $result = false;
            }
        }
        return $result;
    }
}

//Create Submission certification
// if (!function_exists('createSubmissionCertification')) {
//     function createSubmissionCertification($submissions,$test = 0)
//     {
//         $submissions = Submissions::find($submissions->id);
//         $folder = 'upload_file';
//         $visibility = getMediaVisibility();
//         if($submissions->certificate_file && false){
//             $certificate_url = $submissions->certification_url;
//         }else{
//             if($test == 0){
//                 $pdf = PDF::loadView('pdf.certificate', ['submission'=>$submissions]);
//                 $pdfContent = $pdf->output();

//                 $fileName = 'certificate_'.base64_encode($submissions->id).'.pdf';
//                 $path = $folder . '/' . $fileName;

//                 Storage::put($path, $pdfContent, $visibility);
//                 $submissions->certificate_file = $path;
//                 $submissions->save();

//                 $certificate_url = $submissions->certification_url;
//             }else{
//                  // Define the certificate URL
//                 //$certificate_url = "http://192.168.69.185:8000/storage/upload_file/{$fileName}";
//                 $certificate_url = public_path($submissions->certification_url);

//                 try {
//                     $filename = 'certificate_image.jpg';
//                     $diskPath = 'upload_file/' . $filename;


//                     $pdf = new \Spatie\PdfToImage\Pdf($certificate_url);
//                     $pdf->saveImage($diskPath);

//                     // Define the filename and path for the image

//                     // Save the image using Laravel's Storage facade
//                     Storage::put($diskPath, $diskPath, 'public');
//                 } catch (PdfDoesNotExist $e) {
//                     // Handle the case where the PDF does not exist
//                     // Log or handle the exception
//                     dd($e);
//                 }
//             }





//             //$certificate_url = "C:\wamp64\www\clearly_legal_git\storage\app\public\upload_file\certificate_367.pdf";

//             // $pdfContent2 = file_get_contents($certificate_url);

//             // $imagick = new Imagick();
//             // $imagick->readImageBlob($pdfContent2);

//             // // Set the format to JPEG
//             // $imagick->setImageFormat('jpeg');

//             // // Get the image content as a string
//             // $imageContent = $imagick->getImageBlob();

//             // // Define the filename and path for the image
//             // $filename = 'page-12.jpg';
//             // $diskPath = 'upload_file/' . $filename;

//             // // Save the image using Laravel's Storage facade
//             // Storage::put($diskPath, $imageContent, 'public');





//         }
//         $submissions->user->notify(new SendSubmissionReports($certificate_url));
//     }
// }

if (!function_exists('getTempExpireDate')) {
    function getTempExpireDate($value)
    {
        $expire_date = Carbon::parse($value);
        $buffer_period = config('app.expire_buffer_days');
        $temp_expire_date = $expire_date->subDays($buffer_period);
        return Carbon::parse($temp_expire_date);
    }
}


if (!function_exists('getVideoCreditsForBar')) {
        function getVideoCreditsForBar($content_file_id, $user_bar_id)
        {
            $user = User::find(Auth::user()->id);
            $user_bar_subscription=$user->getActiveSubscription($user_bar_id);
            $video_length = ContentFiles::find($content_file_id)->length;
            $sectomins = secondsToMinute($video_length);

            if($user_bar_subscription){
                $credit_provided_by_the_course = $user_bar_subscription->hours_needed_per_cycle;
        
                $creditProvidedByVideoForBar= floor($sectomins/$credit_provided_by_the_course)*0.25;

                return $creditProvidedByVideoForBar;
            }
    }
}   

if (!function_exists('format_date_with_sup')) {
    function format_date_with_sup($dateString)
    {
        // Split into parts
        preg_match('/^([A-Za-z]+)\s+(\d{1,2})$/', $dateString, $matches);

        if (count($matches) !== 3) {
            return $dateString; // Return original if it doesn't match pattern
        }

        $month = $matches[1];
        $day = (int) $matches[2];

        // Get suffix
        if (!in_array(($day % 100), [11, 12, 13])) {
            switch ($day % 10) {
                case 1:  $suffix = 'st'; break;
                case 2:  $suffix = 'nd'; break;
                case 3:  $suffix = 'rd'; break;
                default: $suffix = 'th';
            }
        } else {
            $suffix = 'th';
        }

        return $month . ' ' . $day . '<sup>' . $suffix . '</sup>';
    }
}

if (!function_exists('format_date_with_sup_from_ymd')) {
    function format_date_with_sup_from_ymd($dateString)
    {
        $timestamp = strtotime($dateString);

        if (!$timestamp) {
            return $dateString; // Return original if not a valid date
        }

        $day = (int) date('j', $timestamp); // Day without leading zeros
        $month = date('F', $timestamp);     // Full month name
        $year = date('Y', $timestamp);      // Full year

        // Get suffix
        if (!in_array(($day % 100), [11, 12, 13])) {
            switch ($day % 10) {
                case 1:  $suffix = 'st'; break;
                case 2:  $suffix = 'nd'; break;
                case 3:  $suffix = 'rd'; break;
                default: $suffix = 'th';
            }
        } else {
            $suffix = 'th';
        }
        // return $month . ' ' . $day . '<sup>' . $suffix . '</sup>, ' . $year;
        return $month . ' ' . $day . '<sup>' . $suffix ;
    }
}


if (!function_exists('base64url_encode')) {
// Encoding (when creating the URL)
function base64url_encode($data) {
    return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
}
}

if (!function_exists('crc32_encode')) {
    function crc32_encode($data, $salt = '')
    {
        return dechex(crc32($data . $salt));
    }
}

if (!function_exists('base64url_decode')) {

// Decoding (in your controller)
function base64url_decode($data) {
    return base64_decode(strtr($data, '-_', '+/'));
}
}

if (!function_exists('getCategoryName')) {

// Decoding (in your controller)
function getCategoryName($id) {
    $category = Category::where('id',$id)->first();
    if($category){
        return $category->name;
    }
}
}

function formatPhoneNumber($number)
{
    $clean = preg_replace('/\D/', '', $number);
    if (strlen($clean) === 10) {
        return substr($clean, 0, 3) . '-' . substr($clean, 3, 3) . '-' . substr($clean, 6);
    }
    return $number; // return original if not 10 digits
}


function calculatePrice($percentage)
{
    $base = siteconfig('pricing');
    $result = $base - ($base*($percentage/100));
    return ceil($result);
}