<?php
namespace App\Validators;

use GuzzleHttp\Client;
use App;

class ReCaptcha
{
    public function validate($attribute, $value)
    {
        // Bypass 'recaptcha' validation in testing environment
        if (App::environment('testing')) {
            return true;
        }

        $client = new Client;
        $response = $client->post('https://www.google.com/recaptcha/api/siteverify',
            [
                'form_params' =>
                    [
                        'secret' => env('GOOGLE_RECAPTCHA_SECRET_KEY'),
                        'response' => $value,
                        'attribute' => $attribute
                    ]
            ]
        );

        $body = json_decode((string)$response->getBody());
        
        return $body->success;
    }
}